/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.manager.business;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.appng.api.ActionProvider;
import org.appng.api.DataContainer;
import org.appng.api.DataProvider;
import org.appng.api.Environment;
import org.appng.api.FieldProcessor;
import org.appng.api.Options;
import org.appng.api.Request;
import org.appng.api.model.Application;
import org.appng.api.model.Site;
import org.appng.api.support.OptionOwner;
import org.appng.api.support.SelectionFactory;
import org.appng.application.manager.service.ServiceAware;
import org.appng.core.controller.Session;
import org.appng.xml.platform.Label;
import org.appng.xml.platform.Option;
import org.appng.xml.platform.Selection;
import org.appng.xml.platform.SelectionGroup;
import org.appng.xml.platform.SelectionType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Lazy
@Component
@Scope(value="request")
public class Sessions
extends ServiceAware
implements ActionProvider<Void>,
DataProvider {
    private static final String F_CR_AF = "fCrAf";
    private static final String F_CR_BF = "fCrBf";
    private static final String F_AGNT = "fAgnt";
    private static final String F_SESS = "fSess";
    private static final String F_DMN = "fDmn";
    private static final String F_USR = "fUsr";
    private static final String MM_DD_HH_MM = "yyyy-MM-dd HH:mm";
    private final FastDateFormat hourMinutes = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm");
    @Autowired
    private SelectionFactory selectionFactory;

    public void perform(Site site, Application application, Environment environment, Options options, Request request, Void formBean, FieldProcessor fieldProcessor) {
        String siteName;
        String sessionId = options.getOptionValue("session", "id");
        List sessions = (List)environment.getAttribute(org.appng.api.Scope.PLATFORM, "sessions");
        String currentSession = (String)environment.getAttribute(org.appng.api.Scope.SESSION, "SID");
        Integer siteId = (Integer)request.convert((Object)options.getOptionValue("site", "id"), Integer.class);
        String string = siteName = null == siteId ? null : this.getService().getNameForSite(siteId);
        if (null == sessionId) {
            for (Session session : sessions) {
                this.expire(currentSession, session, siteName);
            }
        } else {
            Session session = (Session)sessions.get(sessions.indexOf(new Session(sessionId)));
            this.expire(currentSession, session, siteName);
        }
        environment.setAttribute(org.appng.api.Scope.SESSION, "expireSessions", (Object)true);
    }

    public DataContainer getData(Site site, Application application, Environment environment, Options options, Request request, FieldProcessor fieldProcessor) {
        DataContainer dataContainer = new DataContainer(fieldProcessor);
        List imutableSessions = (List)environment.getAttribute(org.appng.api.Scope.PLATFORM, "sessions");
        String fDmn = request.getParameter(F_DMN);
        String fSess = request.getParameter(F_SESS);
        String fAgnt = request.getParameter(F_AGNT);
        String fCrBf = request.getParameter(F_CR_BF);
        String fCrAf = request.getParameter(F_CR_AF);
        String fUsr = request.getParameter(F_USR);
        TreeSet<String> userAgents = new TreeSet<String>();
        userAgents.add("");
        Boolean currentSiteOnly = (Boolean)request.convert((Object)options.getOptionValue("site", "currentSiteOnly"), Boolean.class);
        List<Session> sessions = this.getSessions(options, request, currentSiteOnly, imutableSessions, userAgents, fDmn, fSess, fAgnt, fUsr, this.getDate(fCrBf), this.getDate(fCrAf));
        this.addFilters(request, currentSiteOnly, dataContainer, userAgents, fAgnt, fDmn, fUsr);
        dataContainer.setPage(sessions, fieldProcessor.getPageable());
        return dataContainer;
    }

    protected List<Session> getSessions(Options options, Request request, Boolean currentSiteOnly, List<Session> imutableSessions, Set<String> userAgents, String fSite, String fSessid, String fAgnt, String fUsr, Date fcrBfDate, Date fcrAfDate) {
        Integer siteId = (Integer)request.convert((Object)options.getOptionValue("site", "id"), Integer.class);
        String currentSiteName = null == siteId ? null : this.getService().getNameForSite(siteId);
        ArrayList<Session> sessions = new ArrayList<Session>();
        for (Session session : imutableSessions) {
            int idx;
            String userAgent = session.getUserAgent();
            if (StringUtils.isBlank((CharSequence)userAgent)) {
                userAgent = request.getMessage("userAgent.none", new Object[0]);
            }
            if ((idx = userAgent.indexOf(40)) > 0) {
                userAgents.add(userAgent.substring(0, idx));
            } else {
                userAgents.add(userAgent);
            }
            boolean doAdd = true;
            if (Boolean.TRUE.equals(currentSiteOnly) && null != currentSiteName) {
                doAdd = currentSiteName.equals(session.getSite());
            }
            doAdd &= StringUtils.isBlank((CharSequence)fSessid) || session.getId().toLowerCase().startsWith(fSessid.toLowerCase());
            doAdd &= StringUtils.isBlank((CharSequence)fAgnt) || session.getUserAgent().startsWith(fAgnt);
            boolean nameMatches = FilenameUtils.wildcardMatch((String)session.getUser(), (String)fUsr, (IOCase)IOCase.INSENSITIVE);
            doAdd &= StringUtils.isBlank((CharSequence)fUsr) || nameMatches;
            doAdd &= null == fcrAfDate || session.getCreationTime().after(fcrAfDate);
            doAdd &= null == fcrBfDate || session.getCreationTime().before(fcrBfDate);
            if (!(doAdd &= StringUtils.isBlank((CharSequence)fSite) || session.getSite().equals(fSite))) continue;
            Session cloned = session.clone();
            sessions.add(cloned);
            String currentSession = (String)request.getEnvironment().getAttribute(org.appng.api.Scope.SESSION, "SID");
            if (!cloned.getId().equals(currentSession)) continue;
            cloned.setAllowExpire(false);
        }
        return sessions;
    }

    protected void addFilters(Request request, Boolean currentSiteOnly, DataContainer dataContainer, Set<String> userAgents, final String fAgnt, String fDmn, String fUsr) {
        SelectionGroup selectionGroup = new SelectionGroup();
        dataContainer.getSelectionGroups().add(selectionGroup);
        selectionGroup.getSelections().add(this.selectionFactory.getTextSelection(F_SESS, "id", request.getParameter(F_SESS)));
        Selection userAgentFilter = (Selection)this.selectionFactory.fromObjects(F_AGNT, "userAgent", userAgents.toArray(), new OptionOwner.Selector(){

            public void select(Option o) {
                if (o.getValue().equals(fAgnt)) {
                    o.setSelected(Boolean.valueOf(true));
                }
            }
        });
        selectionGroup.getSelections().add(userAgentFilter);
        SelectionFactory.Selection crAfFilter = this.selectionFactory.getDateSelection(F_CR_AF, "createdAfter", request.getParameter(F_CR_AF), MM_DD_HH_MM);
        selectionGroup.getSelections().add(crAfFilter);
        SelectionFactory.Selection crBfFilter = this.selectionFactory.getDateSelection(F_CR_BF, "createdBefore", request.getParameter(F_CR_BF), MM_DD_HH_MM);
        selectionGroup.getSelections().add(crBfFilter);
        if (!currentSiteOnly.booleanValue()) {
            selectionGroup.getSelections().add(this.getDomainFilter(request, fDmn));
        }
        selectionGroup.getSelections().add(this.selectionFactory.getTextSelection(F_USR, "userName", request.getParameter(F_USR)));
    }

    private Date getDate(String dateString) {
        try {
            return StringUtils.isNotBlank((CharSequence)dateString) ? this.hourMinutes.parse(dateString) : null;
        }
        catch (ParseException e) {
            return null;
        }
    }

    protected Selection getDomainFilter(Request request, String fSite) {
        Selection domainFilter = new Selection();
        domainFilter.setId(F_DMN);
        domainFilter.setTitle(new Label());
        domainFilter.getTitle().setId("domain");
        domainFilter.getOptions().add(new Option());
        domainFilter.setType(SelectionType.SELECT);
        Map siteMap = (Map)request.getEnvironment().getAttribute(org.appng.api.Scope.PLATFORM, "sites");
        ArrayList sites = new ArrayList(siteMap.values());
        Collections.sort(sites, new Comparator<Site>(){

            @Override
            public int compare(Site o1, Site o2) {
                return o1.getDomain().compareTo(o2.getDomain());
            }
        });
        for (Site s : sites) {
            Option o = new Option();
            domainFilter.getOptions().add(o);
            o.setValue(s.getName());
            o.setName(s.getDomain());
            o.setSelected(Boolean.valueOf(s.getName().equals(fSite)));
        }
        return domainFilter;
    }

    private void expire(String currentSession, Session session, String siteName) {
        if (!session.getId().equals(currentSession) && (siteName == null || session.getSite().equals(siteName))) {
            session.expire();
        }
    }
}

