/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.manager.business;

import org.appng.api.ActionProvider;
import org.appng.api.BusinessException;
import org.appng.api.DataContainer;
import org.appng.api.DataProvider;
import org.appng.api.Environment;
import org.appng.api.FieldProcessor;
import org.appng.api.Options;
import org.appng.api.Request;
import org.appng.api.model.Application;
import org.appng.api.model.SimpleProperty;
import org.appng.api.model.Site;
import org.appng.application.manager.form.PropertyForm;
import org.appng.application.manager.service.Service;
import org.appng.application.manager.service.ServiceAware;
import org.appng.core.domain.PropertyImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Component;

@Lazy
@Component
@Scope(value="request")
public class Properties
extends ServiceAware
implements ActionProvider<PropertyForm>,
DataProvider {
    private static final Logger log = LoggerFactory.getLogger(Properties.class);
    private static final String PROPERTY = "property";
    private static final String PROPERTIES = "properties";

    public DataContainer getData(Site site, Application application, Environment environment, Options options, Request request, FieldProcessor fp) {
        Service service = this.getService();
        Integer siteId = (Integer)request.convert((Object)options.getOptionValue(PROPERTIES, "siteId"), Integer.class);
        Integer applicationId = (Integer)request.convert((Object)options.getOptionValue(PROPERTIES, "applicationId"), Integer.class);
        String propertyName = (String)request.convert((Object)options.getOptionValue(PROPERTY, "id"), String.class);
        DataContainer data = null;
        if ("create".equals(this.getAction(options))) {
            data = service.getNewProperty(fp);
        } else {
            try {
                data = service.searchProperties(fp, siteId, applicationId, propertyName);
                if (null != data.getItem()) {
                    PropertyForm propertyForm = (PropertyForm)data.getItem();
                    propertyForm.setProperty(new PropertyWrapper((SimpleProperty)propertyForm.getProperty()));
                } else {
                    Page page = data.getPage();
                    data.setPage(page.map((Converter)new Converter<PropertyImpl, PropertyWrapper>(){

                        public PropertyWrapper convert(PropertyImpl p) {
                            return new PropertyWrapper((SimpleProperty)p);
                        }
                    }));
                }
            }
            catch (BusinessException ex) {
                String message = request.getMessage(ex.getMessageKey(), ex.getMessageArgs());
                log.error(message, (Throwable)ex);
                fp.addErrorMessage(message);
            }
        }
        return data;
    }

    public void perform(Site site, Application application, Environment environment, Options options, Request request, PropertyForm propertyForm, FieldProcessor fp) {
        String action = this.getAction(options);
        String errorMessage = null;
        String okMessage = null;
        Service service = this.getService();
        String propertyName = options.getOptionValue(PROPERTY, "id");
        try {
            if ("create".equals(action)) {
                errorMessage = "property.create.error";
                Integer siteId = (Integer)request.convert((Object)options.getOption(PROPERTIES).getAttribute("siteId"), Integer.class);
                Integer applicationId = (Integer)request.convert((Object)options.getOption(PROPERTIES).getAttribute("applicationId"), Integer.class);
                service.createProperty(propertyForm, siteId, applicationId, fp);
                okMessage = "property.created";
            } else if ("update".equals(action)) {
                errorMessage = "property.update.error";
                propertyForm.getProperty().setName(propertyName);
                service.updateProperty(propertyForm, fp);
                okMessage = "property.updated";
            } else if ("delete".equals(action)) {
                errorMessage = "property.delete.error";
                service.deleteProperty(propertyName, fp);
                okMessage = "property.deleted";
            }
            String message = request.getMessage(okMessage, new Object[]{propertyName});
            fp.addOkMessage(message);
        }
        catch (BusinessException ex) {
            String message = request.getMessage(errorMessage, new Object[]{propertyName});
            log.error(message, (Throwable)ex);
            fp.addErrorMessage(message);
        }
    }

    public class PropertyWrapper
    extends PropertyImpl {
        private SimpleProperty property;

        PropertyWrapper(SimpleProperty property) {
            this.property = property;
        }

        public String getActualString() {
            return this.property.getActualString();
        }

        public Boolean getChangedValue() {
            return this.property.getChangedValue();
        }

        public String getShortName() {
            return this.getName().substring(this.getName().lastIndexOf(46) + 1);
        }

        public String getString() {
            return this.property.getString();
        }

        public Boolean getBoolean() {
            return this.property.getBoolean();
        }

        public Integer getInteger() {
            return this.property.getInteger();
        }

        public Float getFloat() {
            return this.property.getFloat();
        }

        public Double getDouble() {
            return this.property.getDouble();
        }

        public byte[] getBlob() {
            return this.property.getBlob();
        }

        public String getClob() {
            return this.property.getClob();
        }

        public String getName() {
            return this.property.getName();
        }

        public boolean isMandatory() {
            return this.property.isMandatory();
        }

        public String getDefaultString() {
            return this.property.getDefaultString();
        }

        public String getDescription() {
            return this.property.getDescription();
        }
    }
}

