/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.manager.business;

import org.appng.api.ActionProvider;
import org.appng.api.BusinessException;
import org.appng.api.DataContainer;
import org.appng.api.DataProvider;
import org.appng.api.Environment;
import org.appng.api.FieldProcessor;
import org.appng.api.Options;
import org.appng.api.Request;
import org.appng.api.model.Application;
import org.appng.api.model.Permission;
import org.appng.api.model.Site;
import org.appng.application.manager.service.Service;
import org.appng.application.manager.service.ServiceAware;
import org.appng.core.domain.PermissionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Lazy
@Component
@Scope(value="request")
public class Permissions
extends ServiceAware
implements ActionProvider<PermissionImpl>,
DataProvider {
    private static final Logger log = LoggerFactory.getLogger(Permissions.class);

    public void perform(Site site, Application application, Environment environment, Options options, Request request, PermissionImpl permission, FieldProcessor fp) {
        block7: {
            String action = this.getAction(options);
            String errorMessage = null;
            String okMessage = null;
            Service service = this.getService();
            Integer permissionId = (Integer)request.convert((Object)options.getOptionValue("id", "id"), Integer.class);
            try {
                if ("create".equals(action)) {
                    Integer applicationId = (Integer)request.convert((Object)options.getOptionValue("application", "id"), Integer.class);
                    service.createPermission(permission, applicationId, fp);
                    okMessage = "permission.created";
                } else if ("update".equals(action)) {
                    permission.setId(permissionId);
                    service.updatePermission((Permission)permission, fp);
                    okMessage = "permission.updated";
                } else if ("delete".equals(action)) {
                    errorMessage = "permission.delete.error";
                    service.deletePermission(permissionId, fp);
                    okMessage = "permission.deleted";
                }
                String message = request.getMessage(okMessage, new Object[]{permissionId});
                fp.addOkMessage(message);
            }
            catch (BusinessException ex) {
                if (null == errorMessage) break block7;
                String message = request.getMessage(errorMessage, new Object[]{permissionId});
                log.error(message, (Throwable)ex);
                fp.addErrorMessage(message);
            }
        }
    }

    public DataContainer getData(Site site, Application application, Environment environment, Options options, Request request, FieldProcessor fp) {
        Service service = this.getService();
        Integer permissionId = (Integer)request.convert((Object)options.getOptionValue("id", "id"), Integer.class);
        Integer applicationId = (Integer)request.convert((Object)options.getOptionValue("application", "id"), Integer.class);
        DataContainer data = null;
        if (permissionId == null && "create".equals(this.getAction(options))) {
            data = service.getNewPermission(fp);
        } else {
            try {
                data = service.searchPermissions(fp, permissionId, applicationId);
            }
            catch (BusinessException ex) {
                String message = request.getMessage(ex.getMessageKey(), ex.getMessageArgs());
                log.error(message, (Throwable)ex);
                fp.addErrorMessage(message);
            }
        }
        return data;
    }
}

