/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.manager.business;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.appng.api.BusinessException;
import org.appng.api.Environment;
import org.appng.api.Request;
import org.appng.api.Webservice;
import org.appng.api.model.Application;
import org.appng.api.model.Site;
import org.appng.api.model.Subject;
import org.appng.application.manager.business.FastAccessFile;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Lazy
@Component
@Scope(value="request")
public class LogViewer
implements Webservice {
    private static final String LOG_LOCATION = "WEB-INF/log/";
    protected static final String PERM_LOG_VIEWER = "platform.logfile";
    @Value(value="${platform.platformRootPath}")
    private String rootPath;
    @Value(value="${platform.logfile}")
    private String logfile;

    public byte[] processRequest(Site site, Application application, Environment environment, Request request) throws BusinessException {
        StringBuilder result = new StringBuilder();
        Subject subject = environment.getSubject();
        if (subject != null && subject.isAuthenticated() && request.getPermissionProcessor().hasPermission(PERM_LOG_VIEWER)) {
            Pattern pattern;
            File logFile = this.getLogfile();
            int maxLines = 1000;
            String parameter = request.getParameter("lines");
            String find = request.getParameter("find");
            Pattern pattern2 = pattern = StringUtils.isBlank((CharSequence)find) ? null : Pattern.compile(find);
            if (null != parameter && parameter.matches("\\d+")) {
                maxLines = Integer.parseInt(parameter);
            }
            try {
                Iterator<String> lines = new FastAccessFile(logFile).tail(maxLines - 1);
                while (lines.hasNext()) {
                    String line = lines.next();
                    if (null != pattern && !pattern.matcher(line).find()) continue;
                    result.append(line);
                    if (!lines.hasNext()) continue;
                    result.append('\n');
                }
            }
            catch (IOException e) {
                throw new BusinessException((Throwable)e);
            }
        }
        return result.toString().getBytes();
    }

    File getLogfile() {
        return new File(this.rootPath, LOG_LOCATION + this.logfile);
    }

    public String getContentType() {
        return "text/plain";
    }
}

