/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.manager.business;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.validation.constraints.NotNull;
import org.apache.commons.io.FileUtils;
import org.appng.api.ActionProvider;
import org.appng.api.ApplicationException;
import org.appng.api.DataContainer;
import org.appng.api.DataProvider;
import org.appng.api.Environment;
import org.appng.api.FieldProcessor;
import org.appng.api.Options;
import org.appng.api.Request;
import org.appng.api.messaging.Event;
import org.appng.api.model.Application;
import org.appng.api.model.Site;
import org.appng.application.manager.business.Constants;
import org.appng.application.manager.business.LogConfigChangedEvent;
import org.appng.application.manager.service.ServiceAware;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Lazy
@Component
@Scope(value="request")
public class LogConfig
extends ServiceAware
implements DataProvider,
ActionProvider<LogFile> {
    static final String LOG4J_PROPS = "WEB-INF/conf/log4j.properties";
    @Value(value="${platform.platformRootPath}")
    private String rootPath;

    public DataContainer getData(Site site, Application application, Environment environment, Options options, Request request, FieldProcessor fp) {
        DataContainer container = new DataContainer(fp);
        LogFile logFile = new LogFile();
        container.setItem((Object)logFile);
        if (!"location".equals(options.getOptionValue("mode", "value"))) {
            try {
                File configFile = this.getConfigFile();
                String content = FileUtils.readFileToString((File)configFile, (Charset)StandardCharsets.UTF_8);
                logFile.setContent(content);
            }
            catch (IOException e) {
                throw new ApplicationException((Throwable)e);
            }
        }
        return container;
    }

    File getConfigFile() {
        return new File(this.rootPath, LOG4J_PROPS);
    }

    public void perform(Site site, Application application, Environment environment, Options options, Request request, LogFile formBean, FieldProcessor fieldProcessor) {
        File configFile = this.getConfigFile();
        try {
            String currentContent = FileUtils.readFileToString((File)configFile, (Charset)StandardCharsets.UTF_8);
            String newContent = formBean.getContent();
            String separator = System.getProperty("line.separator");
            newContent = newContent.replaceAll(Constants.NEW_LINE, separator);
            LogConfigChangedEvent logConfigChangedEvent = new LogConfigChangedEvent(site.getName(), newContent, configFile.getAbsolutePath());
            if (!currentContent.equals(newContent)) {
                logConfigChangedEvent.perform(environment, site);
                if (formBean.clusterWide) {
                    site.sendEvent((Event)logConfigChangedEvent);
                }
                fieldProcessor.addOkMessage(request.getMessage("logconfig.reloaded", new Object[0]));
            } else {
                fieldProcessor.addOkMessage(request.getMessage("logconfig.nochange", new Object[0]));
            }
        }
        catch (Exception e) {
            throw new ApplicationException((Throwable)e);
        }
    }

    public static class LogFile {
        private String content;
        private boolean clusterWide = false;

        @NotNull
        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public boolean isClusterWide() {
            return this.clusterWide;
        }

        public void setClusterWide(boolean clusterWide) {
            this.clusterWide = clusterWide;
        }
    }
}

