/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.manager.business;

import java.util.ArrayList;
import org.appng.api.ActionProvider;
import org.appng.api.BusinessException;
import org.appng.api.DataContainer;
import org.appng.api.DataProvider;
import org.appng.api.Environment;
import org.appng.api.FieldProcessor;
import org.appng.api.Options;
import org.appng.api.Request;
import org.appng.api.model.Application;
import org.appng.api.model.Site;
import org.appng.application.manager.service.Service;
import org.appng.application.manager.service.ServiceAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Lazy
@Component
@Scope(value="request")
public class Installation
extends ServiceAware
implements DataProvider,
ActionProvider<Void> {
    private static final Logger log = LoggerFactory.getLogger(Installation.class);
    public static final String REPOSITORY = "repository";
    private static final String PACKAGE_OPTION = "package";
    private static final String PACKAGE_NAME = "packageName";
    private static final String PACKAGE_VERSION = "packageVersion";
    private static final String PACKAGE_TIMESTAMP = "packageTimestamp";

    public void perform(Site site, Application application, Environment environment, Options options, Request request, Void valueHolder, FieldProcessor fp) {
        String action = this.getAction(options);
        String errorMessage = null;
        String okMessage = null;
        Service service = this.getService();
        Integer repositoryId = (Integer)request.convert((Object)options.getOptionValue(REPOSITORY, "id"), Integer.class);
        String packageName = (String)request.convert((Object)options.getOptionValue(PACKAGE_OPTION, PACKAGE_NAME), String.class);
        String packageVersion = (String)request.convert((Object)options.getOptionValue(PACKAGE_OPTION, PACKAGE_VERSION), String.class);
        String packageTimestamp = (String)request.convert((Object)options.getOptionValue(PACKAGE_OPTION, PACKAGE_TIMESTAMP), String.class);
        try {
            if ("install".equals(action)) {
                errorMessage = "package.install.error";
                service.installPackage(repositoryId, packageName, packageVersion, packageTimestamp, fp);
                okMessage = "package.installed";
                String reloadMessage = request.getMessage("reloadPlatform", new Object[0]);
                fp.addNoticeMessage(reloadMessage);
            } else if ("delete-package".equals(action)) {
                errorMessage = "package.delete.error";
                service.deletePackageVersion(repositoryId, packageName, packageVersion, packageTimestamp, fp);
                okMessage = "package.deleted";
            }
            String message = request.getMessage(okMessage, new Object[]{repositoryId, packageName, packageVersion});
            fp.addOkMessage(message);
        }
        catch (BusinessException ex) {
            String message = request.getMessage(errorMessage, new Object[]{repositoryId, packageName, packageVersion});
            log.error(message, (Throwable)ex);
            fp.addErrorMessage(message);
        }
    }

    public DataContainer getData(Site site, Application application, Environment environment, Options options, Request request, FieldProcessor fp) {
        Service service = this.getService();
        Integer repositoryId = (Integer)request.convert((Object)options.getOptionValue(REPOSITORY, "id"), Integer.class);
        String applicationName = (String)request.convert((Object)options.getOptionValue(PACKAGE_OPTION, PACKAGE_NAME), String.class);
        DataContainer data = new DataContainer(fp);
        try {
            if (null != repositoryId && null == applicationName) {
                data = service.searchInstallablePackages(fp, repositoryId);
            } else if (null != repositoryId && null != applicationName) {
                data = service.searchPackageVersions(fp, repositoryId, applicationName);
            }
        }
        catch (BusinessException ex) {
            data.setPage(new ArrayList(), fp.getPageable());
        }
        return data;
    }
}

