/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.manager.business;

import org.appng.api.ActionProvider;
import org.appng.api.BusinessException;
import org.appng.api.DataContainer;
import org.appng.api.DataProvider;
import org.appng.api.Environment;
import org.appng.api.FieldProcessor;
import org.appng.api.Options;
import org.appng.api.Request;
import org.appng.api.model.Application;
import org.appng.api.model.Site;
import org.appng.application.manager.form.GroupForm;
import org.appng.application.manager.service.Service;
import org.appng.application.manager.service.ServiceAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Lazy
@Component
@Scope(value="request")
public class Groups
extends ServiceAware
implements ActionProvider<GroupForm>,
DataProvider {
    private static final Logger log = LoggerFactory.getLogger(Groups.class);
    private static final String GROUP = "group";

    public void perform(Site site, Application application, Environment environment, Options options, Request request, GroupForm groupForm, FieldProcessor fp) {
        block7: {
            String action = this.getAction(options);
            String errorMessage = null;
            String okMessage = null;
            Service service = this.getService();
            Integer groupId = (Integer)request.convert((Object)options.getOptionValue(GROUP, "id"), Integer.class);
            try {
                if ("create".equals(action)) {
                    service.createGroup(groupForm, site, fp);
                    okMessage = "group.created";
                } else if ("update".equals(action)) {
                    groupForm.getGroup().setId(groupId);
                    service.updateGroup(site, groupForm, fp);
                    okMessage = "group.updated";
                } else if ("delete".equals(action)) {
                    errorMessage = "group.delete.error";
                    service.deleteGroup(groupId, fp);
                    okMessage = "group.deleted";
                }
                String message = request.getMessage(okMessage, new Object[]{groupId});
                fp.addOkMessage(message);
            }
            catch (BusinessException ex) {
                if (null == errorMessage) break block7;
                String message = request.getMessage(errorMessage, new Object[]{groupId});
                log.error(message, (Throwable)ex);
                fp.addErrorMessage(message);
            }
        }
    }

    public DataContainer getData(Site site, Application application, Environment environment, Options options, Request request, FieldProcessor fp) {
        Service service = this.getService();
        Integer groupId = (Integer)request.convert((Object)options.getOptionValue(GROUP, "id"), Integer.class);
        DataContainer data = null;
        if (null == groupId && "create".equals(this.getAction(options))) {
            data = service.getNewGroup(site, fp);
        } else {
            try {
                data = service.searchGroups(fp, site, null, groupId);
            }
            catch (BusinessException ex) {
                String message = request.getMessage(ex.getMessageKey(), ex.getMessageArgs());
                log.error(message, (Throwable)ex);
                fp.addErrorMessage(message);
            }
        }
        return data;
    }
}

