/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.manager.business;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import org.apache.commons.collections.keyvalue.DefaultMapEntry;
import org.appng.api.DataContainer;
import org.appng.api.DataProvider;
import org.appng.api.FieldProcessor;
import org.appng.api.FileUpload;
import org.appng.api.Options;
import org.appng.api.Request;
import org.appng.api.model.Application;
import org.appng.api.model.Site;
import org.appng.application.manager.business.ClusterState;
import org.appng.tools.ui.StringNormalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Lazy
@Component(value="env")
@Scope(value="request")
public class Environment
implements DataProvider {
    private static final Logger log = LoggerFactory.getLogger(ClusterState.class);

    public DataContainer getData(Site site, Application application, org.appng.api.Environment environment, Options options, Request request, FieldProcessor fieldProcessor) {
        String action = options.getOptionValue("mode", "id");
        DataContainer dataContainer = new DataContainer(fieldProcessor);
        Map<Object, Object> entryMap = null;
        if ("env".equals(action)) {
            entryMap = System.getenv();
        } else if ("props".equals(action)) {
            entryMap = System.getProperties();
        } else if ("jvm".equals(action)) {
            entryMap = new HashMap();
            List<String> inputArguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
            for (String arg : inputArguments) {
                int idx = arg.indexOf(61);
                String key = arg;
                String value = "";
                if (idx > 0) {
                    key = arg.substring(0, idx);
                    value = arg.substring(idx + 1);
                }
                entryMap.put(key, value);
            }
        } else if ("mem".equals(action)) {
            entryMap = new HashMap();
            FileUpload.Unit unit = FileUpload.Unit.KB;
            long factor = unit.getFactor();
            DecimalFormat format = new DecimalFormat("  #,###,000  " + unit.name());
            DecimalFormat percentFormat = new DecimalFormat("#0.00 %");
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            this.addUsage(entryMap, factor, format, percentFormat, mBeanServer, "Heap", "Memory", null, "HeapMemoryUsage");
            this.addUsage(entryMap, factor, format, percentFormat, mBeanServer, "Metaspace", "MemoryPool", "Metaspace", "Usage");
        } else if ("proc".equals(action)) {
            entryMap = new HashMap();
            OperatingSystemMXBean osMxBean = ManagementFactory.getOperatingSystemMXBean();
            int procs = osMxBean.getAvailableProcessors();
            double load = osMxBean.getSystemLoadAverage();
            entryMap.put("Processors", Integer.toString(procs));
            entryMap.put("Average Load", Double.toString(load));
        }
        List<Map.Entry<String, ?>> entries = Environment.getSortedEntries(entryMap);
        dataContainer.setPage(entries, fieldProcessor.getPageable());
        return dataContainer;
    }

    protected void addUsage(Map<String, LeveledEntry> entryMap, long factor, DecimalFormat format, DecimalFormat percentFormat, MBeanServer mBeanServer, String entryName, String type, String name, String attributeName) {
        try {
            ObjectName objectName = new ObjectName("java.lang:type=" + type + (null == name ? "" : ",name=" + name));
            CompositeData attribute = (CompositeData)mBeanServer.getAttribute(objectName, attributeName);
            long committed = (Long)attribute.get("committed");
            long max = (Long)attribute.get("max");
            long used = (Long)attribute.get("used");
            entryMap.put(entryName + " Size", new LeveledEntry(format.format((double)committed / (double)factor)));
            entryMap.put(entryName + " Max", new LeveledEntry(max < 0L ? "?" : format.format((double)max / (double)factor)));
            entryMap.put(entryName + " Used", new LeveledEntry(format.format((double)used / (double)factor)));
            if (max > 0L) {
                double percentage = (double)used / (double)max;
                int level = percentage < 0.75 ? 1 : (percentage < 0.85 ? 2 : 3);
                entryMap.put(entryName + " Used (%)", new LeveledEntry(percentFormat.format(percentage), level));
            }
        }
        catch (MBeanException | OperationsException | ReflectionException e) {
            log.error("error adding memory usage", (Throwable)e);
        }
    }

    public static List<Map.Entry<String, ?>> getSortedEntries(Map<?, ?> entryMap) {
        ArrayList<String> keys = new ArrayList<String>();
        for (Object key : entryMap.keySet()) {
            keys.add((String)key);
        }
        ArrayList entries = new ArrayList();
        Collections.sort(keys);
        String qm = "?";
        for (String key : keys) {
            String entryKey = StringNormalizer.replaceNonPrintableCharacters((String)key, (String)qm);
            Object value = entryMap.get(key);
            Object entryValue = value instanceof String ? StringNormalizer.replaceNonPrintableCharacters((String)((String)value), (String)qm) : value;
            entries.add((Map.Entry<String, ?>)new DefaultMapEntry((Object)entryKey, entryValue));
        }
        return entries;
    }

    public class LeveledEntry {
        public static final int LOW = 1;
        public static final int MED = 2;
        public static final int HIGH = 3;
        private String value;
        private int level = 0;

        public LeveledEntry(String value) {
            this.value = value;
        }

        public LeveledEntry(String value, int level) {
            this.value = value;
            this.level = level;
        }

        public String getValue() {
            return this.value;
        }

        public int getLevel() {
            return this.level;
        }
    }
}

