/*
 * Decompiled with CFR 0.152.
 */
package org.appng.forms;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.safety.Whitelist;
import org.owasp.esapi.Encoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XSSUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(XSSUtil.class);
    private static final String XSS_STRIPPED = XSSUtil.class.getName() + ".xssStripped";
    private Encoder encoder;
    private Whitelist whitelist;
    private String[] exceptions;

    public XSSUtil(Encoder encoder) {
        this(encoder, Whitelist.basic(), new String[0]);
    }

    public XSSUtil(Encoder encoder, Whitelist whitelist, String ... exceptions) {
        this.encoder = encoder;
        this.whitelist = whitelist;
        this.exceptions = exceptions;
    }

    public String stripXss(String parameter) {
        if (null == parameter) {
            return parameter;
        }
        return Jsoup.clean((String)this.encoder.canonicalize(parameter), (Whitelist)this.whitelist);
    }

    public String[] stripXss(String[] values) {
        if (values == null) {
            return null;
        }
        String[] encodedValues = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            encodedValues[i] = this.stripXss(values[i]);
        }
        return encodedValues;
    }

    public boolean doProcess(HttpServletRequest request) {
        return this.doProcess(request, this.exceptions);
    }

    public boolean doProcess(HttpServletRequest request, String ... exceptions) {
        if (null != request.getAttribute(XSS_STRIPPED)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("request attribute '{}' is {} for request {}, no need to process", new Object[]{XSS_STRIPPED, request.getAttribute(XSS_STRIPPED), request.getServletPath()});
            }
            return false;
        }
        if (null != exceptions) {
            for (String exception : exceptions) {
                if (StringUtils.isBlank((CharSequence)exception) || exception.startsWith("#") || !request.getServletPath().startsWith(exception.trim())) continue;
                return false;
            }
        }
        return true;
    }

    public void setProcessed(HttpServletRequest request, boolean processed) {
        request.setAttribute(XSS_STRIPPED, (Object)processed);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("setting request attribute '{}' to TRUE for request {}", (Object)XSS_STRIPPED, (Object)request.getServletPath());
        }
    }
}

