/*
 * Decompiled with CFR 0.152.
 */
package org.appng.forms.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FilenameUtils;
import org.appng.forms.FormUpload;
import org.appng.forms.Request;
import org.appng.forms.XSSUtil;
import org.appng.forms.impl.FormUploadBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestBean
implements Request {
    private static final Logger log = LoggerFactory.getLogger(RequestBean.class);
    private static final String POST = "POST";
    private static final String GET = "GET";
    private static final String UTF_8 = "UTF-8";
    private boolean isMultiPart;
    private String encoding = "UTF-8";
    private File tempDir;
    private long maxSize;
    private String method;
    private static final long MAX_SIZE = 0xA00000L;
    private Map<String, List<String>> uploadFileTypes;
    private boolean sizeStrict;
    private boolean isValid;
    private XSSUtil xssUtil;
    private HttpServletRequest httpServletRequest;
    protected Map<String, List<FormUpload>> formUploads;
    protected Map<String, List<String>> parameters;
    protected String host;

    public RequestBean() {
        this(0xA00000L);
    }

    public RequestBean(long maxSize) {
        this(maxSize, null);
    }

    public RequestBean(long maxSize, File tempDir) {
        this.tempDir = tempDir;
        this.maxSize = maxSize;
        this.parameters = new HashMap<String, List<String>>();
        this.uploadFileTypes = new HashMap<String, List<String>>();
        this.formUploads = new HashMap<String, List<FormUpload>>();
    }

    @Override
    public List<FormUpload> getFormUploads(String name) {
        if (this.formUploads.containsKey(name)) {
            return Collections.unmodifiableList(this.formUploads.get(name));
        }
        return Collections.unmodifiableList(new ArrayList());
    }

    @Override
    public void process(HttpServletRequest servletRequest) {
        this.httpServletRequest = servletRequest;
        this.setHost(servletRequest.getServerName());
        if (null == this.tempDir || !this.tempDir.exists()) {
            this.tempDir = new File(System.getProperty("java.io.tmpdir"));
        }
        log.debug("tempdir is " + this.tempDir.getAbsolutePath());
        try {
            log.debug("content type: " + this.httpServletRequest.getContentType());
            log.debug("requestURI: " + this.httpServletRequest.getRequestURI());
            log.debug("contextPath: " + this.httpServletRequest.getContextPath());
            log.debug("servletPath: " + this.httpServletRequest.getServletPath());
            log.debug("pathInfo: " + this.httpServletRequest.getPathInfo());
            this.method = this.httpServletRequest.getMethod().toUpperCase();
            log.debug("request method: " + this.method);
            this.isMultiPart = ServletFileUpload.isMultipartContent((HttpServletRequest)this.httpServletRequest);
            boolean stripXss = this.stripXss();
            if (this.isMultiPart) {
                if (null != this.httpServletRequest.getAttribute(REQUEST_PARSED)) {
                    log.info("the multipart-request {} has been parsed before, parsing is skipped", (Object)this.httpServletRequest);
                    return;
                }
                DiskFileItemFactory fileItemFactory = new DiskFileItemFactory();
                fileItemFactory.setRepository(this.tempDir);
                ServletFileUpload upload = new ServletFileUpload((FileItemFactory)fileItemFactory);
                if (this.sizeStrict) {
                    upload.setFileSizeMax(this.maxSize);
                }
                List items = upload.parseRequest(this.httpServletRequest);
                for (FileItem item : items) {
                    String name = item.getFieldName();
                    if (item.isFormField()) {
                        List<String> list;
                        String value = item.getString(this.getEncoding());
                        if (stripXss) {
                            value = this.xssUtil.stripXss(value);
                        }
                        if ((list = this.parameters.get(name)) == null) {
                            list = new ArrayList<String>();
                            this.parameters.put(name, list);
                        } else {
                            log.trace(this.method + " parameter: " + name + " is multi-valued");
                        }
                        list.add(value);
                        log.trace(this.method + " parameter: " + name + " = " + value);
                        continue;
                    }
                    if (!this.formUploads.containsKey(name)) {
                        this.formUploads.put(name, new ArrayList());
                    }
                    if (item.get().length > 0) {
                        String itemName = item.getName();
                        String extension = FilenameUtils.getExtension((String)itemName);
                        int i = 0;
                        String sessionId = this.httpServletRequest.getSession().getId();
                        File outFile = this.getOutFile(sessionId, extension, i);
                        while (outFile.exists()) {
                            outFile = this.getOutFile(sessionId, extension, ++i);
                        }
                        item.write(outFile);
                        List<String> acceptedTypes = this.getAcceptedTypes(name);
                        FormUploadBean formUpload = new FormUploadBean(outFile, itemName, item.getContentType(), acceptedTypes, this.maxSize);
                        this.formUploads.get(name).add(formUpload);
                        log.trace(this.method + " upload parameter: " + formUpload);
                        continue;
                    }
                    log.debug("nothing uploaded for field " + name);
                }
                servletRequest.setAttribute(REQUEST_PARSED, (Object)this);
            } else {
                Enumeration parameterNames = this.httpServletRequest.getParameterNames();
                while (parameterNames.hasMoreElements()) {
                    ArrayList<String> values;
                    String name = (String)parameterNames.nextElement();
                    String[] parameterValues = this.httpServletRequest.getParameterValues(name);
                    if (stripXss) {
                        parameterValues = this.xssUtil.stripXss(parameterValues);
                    }
                    if ((values = new ArrayList<String>(Arrays.asList(parameterValues))).size() > 1) {
                        log.trace(this.method + " parameter: " + name + " is multi-valued");
                    }
                    this.parameters.put(name, values);
                    log.trace(this.method + " parameter: " + name + " = " + values);
                }
            }
            if (this.xssEnabled()) {
                this.xssUtil.setProcessed(servletRequest, stripXss);
            }
            this.isValid = true;
        }
        catch (Exception e) {
            this.isValid = false;
            log.error("Error while processing form data: ", (Throwable)e);
        }
    }

    private boolean stripXss() {
        return this.xssEnabled() && this.xssUtil.doProcess(this.httpServletRequest);
    }

    private boolean xssEnabled() {
        return null != this.xssUtil;
    }

    private File getOutFile(String sessionId, String extension, int count) {
        return new File(this.tempDir, sessionId + "_" + count + "." + extension);
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public boolean isMultiPart() {
        return this.isMultiPart;
    }

    @Override
    public boolean isPost() {
        return POST.equalsIgnoreCase(this.method);
    }

    @Override
    public boolean isGet() {
        return GET.equalsIgnoreCase(this.method);
    }

    @Override
    public void setTempDir(File tempDir) {
        this.tempDir = tempDir;
    }

    @Override
    public void setMaxSize(long maxSize) {
        this.setMaxSize(maxSize, false);
    }

    @Override
    public void setMaxSize(long maxSize, boolean isStrict) {
        this.maxSize = maxSize;
        this.sizeStrict = isStrict;
    }

    @Override
    public void setAcceptedTypes(String uploadName, String ... types) {
        if (!this.uploadFileTypes.containsKey(uploadName)) {
            this.uploadFileTypes.put(uploadName, new ArrayList());
        }
        this.uploadFileTypes.get(uploadName).clear();
        if (null != types) {
            for (String extension : types) {
                this.uploadFileTypes.get(uploadName).add(extension.toLowerCase());
            }
        }
    }

    @Override
    public List<String> getAcceptedTypes(String uploadName) {
        return this.uploadFileTypes.get(uploadName);
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public HttpServletRequest getHttpServletRequest() {
        return this.httpServletRequest;
    }

    @Override
    public void addParameter(String key, String value) {
        if (!this.parameters.containsKey(key)) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(value);
            this.parameters.put(key, Collections.unmodifiableList(list));
            log.debug("adding parameter " + key + ":" + value);
        }
    }

    @Override
    public void addParameters(Map<String, String> singleParameters) {
        for (String key : singleParameters.keySet()) {
            this.addParameter(key, singleParameters.get(key));
        }
    }

    @Override
    public Map<String, List<FormUpload>> getFormUploads() {
        return Collections.unmodifiableMap(this.formUploads);
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public String getParameter(String name) {
        return this.getSingleParameter(name);
    }

    @Override
    public List<String> getParameterList(String name) {
        List<String> list = this.parameters.get(name);
        if (null == list) {
            list = new ArrayList<String>();
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    public Set<String> getParameterNames() {
        return Collections.unmodifiableSet(this.parameters.keySet());
    }

    @Override
    public Map<String, String> getParameters() {
        Set<String> keySet = this.parameters.keySet();
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : keySet) {
            String value = this.getSingleParameter(key);
            if (null == value) continue;
            map.put(key, value);
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    public Map<String, List<String>> getParametersList() {
        return Collections.unmodifiableMap(this.parameters);
    }

    String getSingleParameter(String name) {
        String value = null;
        List<String> list = this.parameters.get(name);
        if (list != null) {
            int size = list.size();
            if (size > 0) {
                value = list.get(0);
            }
            if (size > 1) {
                log.trace("parameter '" + name + "' is multi-valued, discarding value(s) " + list.subList(1, size));
            }
        }
        return value;
    }

    @Override
    public boolean hasParameter(String name) {
        return this.getParameterNames().contains(name);
    }

    public void setHost(String host) {
        this.host = host;
    }

    public XSSUtil getXssUtil() {
        return this.xssUtil;
    }

    public void setXssUtil(XSSUtil xssUtil) {
        this.xssUtil = xssUtil;
    }
}

