/*
 * Decompiled with CFR 0.152.
 */
package org.appng.forms.impl;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.appng.forms.FormUpload;
import org.appng.forms.FormUploadValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormUploadBean
implements FormUpload {
    private static final Logger log = LoggerFactory.getLogger(FormUploadBean.class);
    private String originalName;
    private File file;
    private String contentType;
    private List<String> acceptedTypes;
    private long maxSize = -1L;
    private long minSize = 0L;

    public FormUploadBean(File file, String originalName, String contentType, List<String> acceptedTypes, long maxSize) {
        this.file = file;
        this.originalName = FilenameUtils.getName((String)originalName);
        this.contentType = contentType;
        this.acceptedTypes = acceptedTypes;
        this.maxSize = maxSize;
    }

    @Override
    public List<String> getAcceptedTypes() {
        return Collections.unmodifiableList(this.acceptedTypes);
    }

    @Override
    public String getOriginalFilename() {
        return this.originalName;
    }

    @Override
    public File getFile() {
        if (!this.isValidFile()) {
            return null;
        }
        return this.file;
    }

    @Override
    public long size() {
        if (null == this.file) {
            return 0L;
        }
        return this.file.length();
    }

    @Override
    public long getMaxSize() {
        return this.maxSize;
    }

    @Override
    public long getMinSize() {
        return this.minSize;
    }

    @Override
    public byte[] getBytes() {
        if (!this.isValidFile()) {
            return null;
        }
        try {
            return FileUtils.readFileToByteArray((File)this.getFile());
        }
        catch (IOException e) {
            log.error("error while reading file", (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean isValidSize() {
        return (this.maxSize == -1L || this.maxSize >= this.file.length()) && this.file.length() >= this.minSize;
    }

    @Override
    public boolean isValid() {
        return this.isValidFile() && this.isValidType() && this.isValidSize() && this.isValidName();
    }

    private boolean isValidName() {
        return null != this.originalName && !"".equals(this.originalName);
    }

    @Override
    public boolean isValid(String[] types, long minSize, long maxSize) {
        this.acceptedTypes = Arrays.asList(types);
        this.maxSize = maxSize;
        this.minSize = minSize;
        return this.isValid();
    }

    @Override
    public boolean isValid(FormUploadValidator validator) {
        return validator.isValid(this);
    }

    @Override
    public boolean isValid(Class<? extends FormUploadValidator> validatorClass) {
        try {
            FormUploadValidator validator = validatorClass.newInstance();
            return this.isValid(validator);
        }
        catch (Exception e) {
            log.error("unable to instanciate validator class '" + validatorClass.getName() + "'", (Throwable)e);
            return true;
        }
    }

    @Override
    public boolean isValidFile() {
        return this.file != null && this.file.exists() && this.file.isFile();
    }

    @Override
    public boolean isValidType() {
        String extension = FilenameUtils.getExtension((String)this.getOriginalFilename());
        if (null != extension) {
            extension = extension.toLowerCase();
        }
        return this.acceptedTypes == null || this.acceptedTypes.size() == 0 || this.acceptedTypes.indexOf(extension) > -1 || this.acceptedTypes.indexOf(this.getContentType()) > -1;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    public String toString() {
        return this.file.getAbsolutePath() + " (size " + this.file.length() + ", type: " + this.contentType + ", original name:" + this.originalName + ")";
    }
}

