/*
 * Decompiled with CFR 0.152.
 */
package org.appng.el;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.el.ArrayELResolver;
import javax.el.BeanELResolver;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.FunctionMapper;
import javax.el.ListELResolver;
import javax.el.MapELResolver;
import javax.el.ValueExpression;
import org.apache.jasper.el.ELContextImpl;
import org.appng.el.VariableMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExpressionEvaluator {
    private static final Logger log = LoggerFactory.getLogger(ExpressionEvaluator.class);
    private ExpressionFactory ef;
    private ELContext ctx;
    private VariableMapper variableMapper;
    private final Map<String, Method> methods = new HashMap<String, Method>();

    public ExpressionEvaluator(Map<String, ?> variables) {
        this.ef = ExpressionFactory.newInstance();
        CompositeELResolver resolver = new CompositeELResolver();
        resolver.add((ELResolver)new MapELResolver());
        resolver.add((ELResolver)new ListELResolver());
        resolver.add((ELResolver)new ArrayELResolver());
        resolver.add((ELResolver)new BeanELResolver());
        this.ctx = new ELContextImpl((ELResolver)resolver);
        this.variableMapper = new VariableMapper(this.ctx, this.ef);
        ((ELContextImpl)this.ctx).setVariableMapper((javax.el.VariableMapper)this.variableMapper);
        ((ELContextImpl)this.ctx).setFunctionMapper(this.getFunctionMapper());
        this.setVariables(variables);
    }

    public final <T> T evaluate(String expression, Class<T> targetType) {
        Object value;
        ValueExpression ve = this.ef.createValueExpression(this.ctx, expression, targetType);
        Object result = value = ve.getValue(this.ctx);
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(expression + " = " + result + " [");
            sb.append(this.variableMapper.toString());
            sb.append("]");
            log.debug(sb.toString());
        }
        return (T)result;
    }

    public final boolean evaluate(String expression) {
        return this.evaluate(expression, Boolean.TYPE);
    }

    public final void addFunction(String prefix, String name, Method method) {
        this.putFunction(prefix + ":" + name, method);
    }

    public final void addFunction(String name, Method method) {
        this.putFunction(":" + name, method);
    }

    private void putFunction(String methodName, Method method) {
        this.methods.put(methodName, method);
        log.debug("registered function '" + methodName + "' with method '" + method + ",");
    }

    private FunctionMapper getFunctionMapper() {
        FunctionMapper functionMapper = new FunctionMapper(){

            public final Method resolveFunction(String prefix, String localname) {
                Method method = (Method)ExpressionEvaluator.this.methods.get(prefix + ":" + localname);
                return method;
            }
        };
        return functionMapper;
    }

    public final void setVariable(String name, Object value) {
        this.setVariable(name, value, value.getClass());
    }

    private final void setVariable(String name, Object value, Class<?> type) {
        ValueExpression expression = this.ef.createValueExpression(value, type);
        this.variableMapper.setVariable(name, expression);
        if (null == value) {
            log.trace("setting variable '" + name + "' to null");
        } else if (value instanceof String || value instanceof Number) {
            log.trace("setting variable '" + name + "' of type '" + type.getName() + "' to value '" + value.toString() + "'");
        }
    }

    public final void setVariables(Map<String, ?> variables) {
        for (String key : variables.keySet()) {
            this.setVariable(key, variables.get(key));
        }
    }

    public boolean isExpression(String value) {
        return null != value && value.matches("\\$\\{.*\\}");
    }

    public String getString(String expression) {
        if (this.isExpression(expression)) {
            return this.evaluate(expression, String.class);
        }
        return expression;
    }

    public Boolean getBoolean(String expression) {
        if (this.isExpression(expression)) {
            return this.evaluate(expression);
        }
        if (expression != null) {
            return Boolean.valueOf(expression);
        }
        return null;
    }
}

