/*
 * Decompiled with CFR 0.152.
 */
package org.appng.cli.servlet;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.appng.cli.CliBootstrap;
import org.appng.cli.CliEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallListener
implements ServletContextListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstallListener.class);
    private static final String DATE_PATTERN = "yyyy-MM-dd-HH-mm";
    private static final String BATCH_FILE = "auto-install.list";
    private static final String INSTALL_PATH = "/WEB-INF/conf/auto-install.list";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void contextInitialized(ServletContextEvent sce) {
        block33: {
            File autoInstall;
            ServletContext ctx = sce.getServletContext();
            String appngData = System.getProperty("appngData");
            if (StringUtils.isBlank((CharSequence)appngData)) {
                String resource = ctx.getRealPath(INSTALL_PATH);
                if (null == resource) {
                    LOGGER.info("{} not present", (Object)INSTALL_PATH);
                    return;
                }
                autoInstall = new File(resource);
            } else {
                autoInstall = Paths.get(appngData, "conf", BATCH_FILE).toFile();
            }
            String message = null;
            if (autoInstall.exists()) {
                LOGGER.info("processing {}", (Object)autoInstall);
                System.getProperties().put("APPNG_HOME", ctx.getRealPath("/"));
                try (ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();){
                    CliEnvironment.out = new PrintStream(bytesOut);
                    String[] args = new String[]{"batch", "-f", autoInstall.getAbsolutePath()};
                    int status = CliBootstrap.run(args);
                    message = new String(bytesOut.toByteArray());
                    LOGGER.debug(message);
                    if (0 != status) {
                        LOGGER.warn("CLI returned status {}", (Object)status);
                    }
                    LOGGER.info("done processing {}", (Object)autoInstall);
                }
            } else {
                LOGGER.debug("{} not present", (Object)autoInstall);
            }
            if (null == autoInstall || !autoInstall.exists()) break block33;
            String timestamp = DateFormatUtils.format((long)System.currentTimeMillis(), (String)DATE_PATTERN);
            String targetName = "auto-install.list." + timestamp;
            File processingResult = new File(autoInstall.getParent(), targetName);
            try {
                if (null != message) {
                    FileUtils.write((File)processingResult, message, (Charset)Charset.defaultCharset(), (boolean)false);
                    FileUtils.deleteQuietly((File)autoInstall);
                    break block33;
                }
                FileUtils.moveFile((File)autoInstall, (File)processingResult);
            }
            catch (IOException e) {
                LOGGER.warn(String.format("error while creating %s", processingResult.getPath()), (Throwable)e);
            }
            break block33;
            catch (Exception e) {
                try {
                    LOGGER.error(String.format("error while processing %s", autoInstall), (Throwable)e);
                    if (null == autoInstall || !autoInstall.exists()) break block33;
                }
                catch (Throwable throwable) {
                    if (null != autoInstall && autoInstall.exists()) {
                        String timestamp2 = DateFormatUtils.format((long)System.currentTimeMillis(), (String)DATE_PATTERN);
                        String targetName2 = "auto-install.list." + timestamp2;
                        File processingResult2 = new File(autoInstall.getParent(), targetName2);
                        try {
                            if (null != message) {
                                FileUtils.write((File)processingResult2, message, (Charset)Charset.defaultCharset(), (boolean)false);
                                FileUtils.deleteQuietly((File)autoInstall);
                            } else {
                                FileUtils.moveFile((File)autoInstall, (File)processingResult2);
                            }
                        }
                        catch (IOException e2) {
                            LOGGER.warn(String.format("error while creating %s", processingResult2.getPath()), (Throwable)e2);
                        }
                    }
                    throw throwable;
                }
                timestamp = DateFormatUtils.format((long)System.currentTimeMillis(), (String)DATE_PATTERN);
                targetName = "auto-install.list." + timestamp;
                processingResult = new File(autoInstall.getParent(), targetName);
                try {
                    if (null != message) {
                        FileUtils.write((File)processingResult, message, (Charset)Charset.defaultCharset(), (boolean)false);
                        FileUtils.deleteQuietly((File)autoInstall);
                    }
                    FileUtils.moveFile((File)autoInstall, (File)processingResult);
                }
                catch (IOException e3) {
                    LOGGER.warn(String.format("error while creating %s", processingResult.getPath()), (Throwable)e3);
                }
            }
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

