/*
 * Decompiled with CFR 0.152.
 */
package org.appng.cli.commands.subject;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.appng.api.BusinessException;
import org.appng.api.model.AuthSubject;
import org.appng.cli.CliEnvironment;
import org.appng.cli.ExecutableCliCommand;
import org.appng.core.security.DefaultPasswordPolicy;
import org.appng.core.security.PasswordHandler;

@Parameters(commandDescription="Hashes a password.")
public class HashPassword
implements ExecutableCliCommand {
    @Parameter(required=false, description="<cleartext-password>")
    private String password;
    @Parameter(names={"-i"}, required=false, description="Enables interactive mode.")
    private boolean interactive = false;

    public HashPassword() {
    }

    HashPassword(String password) {
        this.password = password;
    }

    HashPassword(boolean interactive) {
        this.interactive = interactive;
    }

    @Override
    public void execute(CliEnvironment cle) throws BusinessException {
        boolean passwordSet = StringUtils.isNotBlank((CharSequence)this.password);
        if (!this.interactive && !passwordSet) {
            throw new BusinessException("Either password must be given or -i must be set!");
        }
        if (this.interactive) {
            this.runInteractive(cle);
            return;
        }
        String digest = HashPassword.savePasswordForSubject(cle, new PasswordSubject(), this.password);
        cle.setResult(digest);
    }

    private void runInteractive(CliEnvironment cle) throws BusinessException {
        try {
            BufferedReader console = new BufferedReader(new InputStreamReader(System.in));
            Throwable throwable = null;
            try {
                try {
                    try {
                        CliEnvironment.out.println("Hashes a password. Type CTRL + C to quit.");
                        while (true) {
                            try {
                                while (true) {
                                    CliEnvironment.out.print("password: ");
                                    String commandLine = console.readLine();
                                    if (null == StringUtils.trimToNull((String)commandLine)) continue;
                                    String digest = HashPassword.savePasswordForSubject(cle, new PasswordSubject(), commandLine);
                                    CliEnvironment.out.print("hash: ");
                                    CliEnvironment.out.println(digest);
                                }
                            }
                            catch (BusinessException e) {
                                CliEnvironment.out.println(e.getMessage());
                                continue;
                            }
                            break;
                        }
                    }
                    catch (IOException e) {
                        throw new BusinessException((Throwable)e);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (console != null) {
                    if (throwable != null) {
                        try {
                            console.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        console.close();
                    }
                }
                throw throwable3;
            }
        }
        catch (IOException e1) {
            throw new BusinessException((Throwable)e1);
        }
    }

    static String savePasswordForSubject(CliEnvironment cle, AuthSubject subject, String password) throws BusinessException {
        String errorMessageKey;
        String regEx = cle.getPlatformConfig().getString("passwordPolicyRegEx");
        if (!new DefaultPasswordPolicy(regEx, errorMessageKey = cle.getPlatformConfig().getString("passwordPolicyErrorMessageKey")).isValidPassword(password.toCharArray())) {
            String errorMessage = cle.getMessageSource().getMessage(errorMessageKey, null, Locale.ENGLISH);
            throw new BusinessException(errorMessage);
        }
        PasswordHandler passwordHandler = cle.getCoreService().getDefaultPasswordHandler(subject);
        passwordHandler.savePassword(password);
        return subject.getDigest();
    }

    static class PasswordSubject
    implements AuthSubject {
        private String digest;

        PasswordSubject() {
        }

        public String getDigest() {
            return this.digest;
        }

        public void setDigest(String digest) {
            this.digest = digest;
        }

        public String getAuthName() {
            return null;
        }

        public String getRealname() {
            return null;
        }

        public String getLanguage() {
            return null;
        }

        public String getTimeZone() {
            return null;
        }

        public String getEmail() {
            return null;
        }

        public String getSalt() {
            return null;
        }

        public void setSalt(String salt) {
        }
    }
}

