/*
 * Decompiled with CFR 0.152.
 */
package org.appng.cli.commands.subject;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import org.apache.commons.lang3.StringUtils;
import org.appng.api.BusinessException;
import org.appng.api.model.AuthSubject;
import org.appng.api.model.UserType;
import org.appng.cli.CliEnvironment;
import org.appng.cli.ExecutableCliCommand;
import org.appng.cli.commands.subject.HashPassword;
import org.appng.core.domain.SubjectImpl;

@Parameters(commandDescription="Creates a subject.")
public class CreateSubject
implements ExecutableCliCommand {
    @Parameter(names={"-u"}, required=true, description="The user name.")
    private String loginName;
    @Parameter(names={"-n"}, required=true, description="The real name.")
    private String realName;
    @Parameter(names={"-e"}, required=true, description="The e-mail address.")
    private String email;
    @Parameter(names={"-p"}, required=false, description="The password, mandatory for type LOCAL_USER.")
    private String password;
    @Parameter(names={"-h"}, required=false, description="Has the password already been hashed using 'hash-pw <password>'?")
    private boolean passwordHashed = false;
    @Parameter(names={"-l"}, required=false, description="GUI language of the user.")
    private String language = "de";
    @Parameter(names={"-d"}, required=false, description="Description of the user.")
    private String description = "";
    @Parameter(names={"-t"}, required=false, description="The type of the user.")
    private UserType type = UserType.LOCAL_USER;

    public CreateSubject() {
    }

    CreateSubject(String loginName, String realName, String email, String password, String language, String description, UserType type, boolean passwordHashed) {
        this.loginName = loginName;
        this.realName = realName;
        this.email = email;
        this.password = password;
        this.language = language;
        this.description = description;
        this.type = type;
        this.passwordHashed = passwordHashed;
    }

    @Override
    public void execute(CliEnvironment cle) throws BusinessException {
        SubjectImpl subject = new SubjectImpl();
        if (UserType.LOCAL_USER.equals((Object)this.type)) {
            if (StringUtils.isBlank((CharSequence)this.password)) {
                throw new BusinessException(String.format("-p is mandatory for type %s", this.type.name()));
            }
            if (!this.passwordHashed) {
                HashPassword.savePasswordForSubject(cle, (AuthSubject)subject, this.password);
            }
        } else if (StringUtils.isNotBlank((CharSequence)this.password)) {
            throw new BusinessException(String.format("-p is not allowed for type %s", this.type.name()));
        }
        if (null != cle.getCoreService().getSubjectByName(this.loginName, false)) {
            throw new BusinessException(String.format("Subject with name '%s' already exists.", this.loginName));
        }
        subject.setName(this.loginName);
        subject.setRealname(this.realName);
        subject.setEmail(this.email);
        subject.setLanguage(this.language);
        subject.setDescription(this.description);
        subject.setUserType(this.type);
        if (this.passwordHashed) {
            subject.setDigest(this.password);
        }
        cle.getCoreService().createSubject(subject);
    }
}

