/*
 * Decompiled with CFR 0.152.
 */
package org.appng.cli.commands.repository;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.appng.api.BusinessException;
import org.appng.cli.CliEnvironment;
import org.appng.cli.ExecutableCliCommand;
import org.appng.core.domain.RepositoryImpl;
import org.appng.core.model.Repository;
import org.appng.core.model.RepositoryCacheFactory;
import org.appng.core.model.RepositoryMode;
import org.appng.core.model.RepositoryType;

@Parameters(commandDescription="Creates a repository.")
public class CreateRepository
implements ExecutableCliCommand {
    @Parameter(names={"-n"}, required=true, description="The repository name.")
    private String name;
    @Parameter(names={"-d"}, required=false, description="The repository description.")
    private String description;
    @Parameter(names={"-t"}, required=false, description="The repository type (LOCAL, REMOTE).")
    private RepositoryType type = RepositoryType.getDefault();
    @Parameter(names={"-m"}, required=false, description="The repository mode (ALL, STABLE, SNAPSHOT).")
    private RepositoryMode mode = RepositoryMode.getDefault();
    @Parameter(names={"-u"}, required=true, description="The path (URI) to the repository.")
    private String uriString;
    @Parameter(names={"-r"}, required=false, description="The name of the remote repository (required for repository type REMOTE).")
    private String remoteRepositoryName;
    @Parameter(names={"-g"}, required=false, description="The digest for the repository.")
    private String digest;
    @Parameter(names={"-e"}, description="Enable repository.", arity=1)
    private boolean isActive = true;
    @Parameter(names={"-p"}, description="Publish repository.")
    private boolean isPublished = false;
    @Parameter(names={"-s"}, description="Use strict mode.")
    private Boolean isStrict = false;

    @Override
    public void execute(CliEnvironment cle) throws BusinessException {
        try {
            boolean isRemote = RepositoryType.REMOTE.equals((Object)this.type);
            if (isRemote && StringUtils.isBlank((CharSequence)this.remoteRepositoryName)) {
                throw new BusinessException("The missing parameter -r must contain the name of the remote repository.");
            }
            URI uri = new URI(this.uriString);
            if (this.type.equals((Object)RepositoryType.LOCAL)) {
                File path = new File(uri);
                if (path.exists()) {
                    if (!path.isDirectory()) {
                        throw new BusinessException("Must be a directory, but is a file: " + path.getAbsolutePath());
                    }
                } else {
                    try {
                        FileUtils.forceMkdir((File)path);
                    }
                    catch (IOException e) {
                        throw new BusinessException("Can not create directory: " + path.getAbsolutePath(), (Throwable)e);
                    }
                }
            }
            RepositoryImpl repository = new RepositoryImpl();
            repository.setName(this.name);
            repository.setDescription(this.description);
            repository.setRepositoryType(this.type);
            repository.setRepositoryMode(this.mode);
            if (isRemote) {
                repository.setRemoteRepositoryName(this.remoteRepositoryName);
            } else {
                repository.setPublished(this.isPublished);
            }
            repository.setDigest(this.digest);
            repository.setActive(this.isActive);
            repository.setStrict(this.isStrict.booleanValue());
            repository.setUri(uri);
            RepositoryCacheFactory.validateRepositoryURI((Repository)repository);
            cle.getCoreService().createRepository(repository);
        }
        catch (URISyntaxException u) {
            throw new BusinessException("Not a valid URI: " + this.uriString, (Throwable)u);
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
    }
}

