/*
 * Decompiled with CFR 0.152.
 */
package org.appng.cli.commands.platform;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.converters.FileConverter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.appng.api.BusinessException;
import org.appng.api.model.Properties;
import org.appng.cli.CliEnvironment;
import org.appng.cli.ExecutableCliCommand;
import org.appng.core.domain.PropertyImpl;

@Parameters(commandDescription="Extracts the data from $APPNG_HOME to the given folder.")
public class ExtractData
implements ExecutableCliCommand {
    private static final String CONF = "conf";
    private static final String LOG = "log";
    private static final String WEB_XML = "web.xml";
    private static final String WEB_INF = "WEB-INF";
    private static final String PRIVILEGED_CONTEXT = "<Context privileged=\"true\">";
    private static final String NEWLINE = "\r\n";
    private static final String $APPNG_HOME = "${appng.home}";
    private static final String $APPNG_DATA = "${appng.data}";
    private static final String $WEBAPP_ROOT = "${webapp.root}/WEB-INF";
    @Parameter(names={"-appngData"}, required=true, description="The folder to extract the data to.", converter=FileConverter.class)
    private File appngData;
    @Parameter(names={"-copy"}, description="Copy data instead of moving.")
    private boolean copy = false;
    @Parameter(names={"-revert"}, description="Revert previously extracted data.")
    private boolean revert = false;

    @Override
    public void execute(CliEnvironment cle) throws BusinessException {
        if (this.appngData.isFile()) {
            CliEnvironment.out.println(String.format("%s is a not a directory!", this.appngData));
            return;
        }
        this.appngData.mkdirs();
        Properties platformConfig = cle.getPlatformConfig();
        String appngHome = platformConfig.getString("platformRootPath");
        String applicationDir = platformConfig.getString("applicationDir");
        String repositoryPath = platformConfig.getString("repositoryPath");
        this.extract(appngHome, cle, applicationDir, repositoryPath);
    }

    protected void extract(String appngHome, CliEnvironment cle, String applicationDir, String repositoryPath) throws BusinessException {
        try {
            this.move(Paths.get(appngHome, WEB_INF, WEB_XML), Paths.get(this.appngData.toString(), WEB_INF, WEB_XML));
            this.move(Paths.get(appngHome, WEB_INF, CONF), Paths.get(this.appngData.toString(), CONF));
            this.move(Paths.get(appngHome, WEB_INF, LOG), Paths.get(this.appngData.toString(), LOG));
            this.move(Paths.get(appngHome, applicationDir), Paths.get(this.appngData.toString(), applicationDir));
            this.move(Paths.get(appngHome, repositoryPath), Paths.get(this.appngData.toString(), repositoryPath));
            this.writeContextXml(appngHome);
            this.setCacheConfig(cle);
            File log4jProperties = Paths.get(this.appngData.toString(), CONF, "log4j.properties").toFile();
            if (this.revert) {
                ExtractData.replaceInFile(log4jProperties, $APPNG_DATA, $WEBAPP_ROOT);
            } else {
                ExtractData.replaceInFile(log4jProperties, $WEBAPP_ROOT, $APPNG_DATA);
                File binFolder = new File(this.appngData, "bin");
                binFolder.mkdirs();
                this.copyBatchFileToBin(binFolder, this.appngData.toString(), appngHome, "appng");
                this.copyBatchFileToBin(binFolder, this.appngData.toString(), appngHome, "appng.bat");
            }
        }
        catch (IOException | URISyntaxException e) {
            throw new BusinessException((Throwable)e);
        }
    }

    protected void copyBatchFileToBin(File binFolder, String appngData, String appngHome, String name) throws IOException {
        File targetFile = new File(binFolder, name);
        try (InputStream is = this.getClass().getResourceAsStream(name);
             FileWriter fw = new FileWriter(targetFile);){
            IOUtils.copy((InputStream)is, (Writer)fw, (Charset)StandardCharsets.UTF_8);
        }
        targetFile.setExecutable(true, true);
        ExtractData.replaceInFile(targetFile, $APPNG_DATA, appngData.toString());
        ExtractData.replaceInFile(targetFile, $APPNG_HOME, appngHome);
    }

    protected void writeContextXml(String appngHome) throws IOException, URISyntaxException {
        Path contextXml = Paths.get(appngHome, "META-INF", "context.xml");
        Charset charset = StandardCharsets.UTF_8;
        String contextXmlContent = new String(Files.readAllBytes(contextXml), charset);
        URL resource = this.getClass().getClassLoader().getResource("context-resources.xml");
        try (FileSystem fs = FileSystems.newFileSystem(resource.toURI(), new HashMap());){
            String resources = new String(Files.readAllBytes(Paths.get(resource.toURI())), charset);
            String resourceContext = "<Context privileged=\"true\">\r\n" + resources;
            contextXmlContent = this.revert ? contextXmlContent.replace(resourceContext, PRIVILEGED_CONTEXT) : contextXmlContent.replace(PRIVILEGED_CONTEXT, resourceContext);
            Files.write(contextXml, contextXmlContent.getBytes(charset), new OpenOption[0]);
            CliEnvironment.out.println(String.format("Updated %s", contextXml.toString()));
        }
    }

    protected void setCacheConfig(CliEnvironment cle) {
        PropertyImpl ehcacheConfig = cle.getCoreService().getProperty("platform.ehcacheConfig");
        String defaultValue = "conf/ehcache.xml";
        if (this.revert) {
            defaultValue = "WEB-INF/" + defaultValue;
        }
        ehcacheConfig.setString(defaultValue);
        CliEnvironment.out.println(String.format("Setting default value for %s: %s", ehcacheConfig.getName(), defaultValue));
        cle.getCoreService().saveProperty(ehcacheConfig);
    }

    private File move(Path source, Path target) throws IOException {
        File targetFile;
        File sourceFile = this.revert ? target.toFile() : source.toFile();
        File file = targetFile = this.revert ? source.toFile() : target.toFile();
        if (sourceFile.exists()) {
            return this.moveResource(sourceFile, targetFile);
        }
        CliEnvironment.out.println(String.format("%s does not exist.", sourceFile));
        return null;
    }

    protected static void replaceInFile(File file, String search, String replacement) throws IOException {
        Path path = file.toPath();
        Charset charset = StandardCharsets.UTF_8;
        String content = new String(Files.readAllBytes(path), charset);
        content = content.replaceAll(Pattern.quote(search), Matcher.quoteReplacement(replacement));
        Files.write(path, content.getBytes(charset), new OpenOption[0]);
        CliEnvironment.out.println("Replaced " + search + " with " + replacement + " in " + path);
    }

    private File moveResource(File sourceFile, File targetFile) throws IOException {
        if (this.copy) {
            if (sourceFile.isFile()) {
                FileUtils.copyFile((File)sourceFile, (File)targetFile, (boolean)true);
            } else {
                FileUtils.copyDirectory((File)sourceFile, (File)targetFile, (boolean)true);
            }
        } else if (sourceFile.isFile()) {
            FileUtils.moveFile((File)sourceFile, (File)targetFile);
        } else {
            FileUtils.moveDirectory((File)sourceFile, (File)targetFile);
        }
        CliEnvironment.out.println(String.format("%s\t%s -> %s", this.copy ? "copied" : "moved", sourceFile, targetFile));
        return targetFile;
    }
}

