/*
 * Decompiled with CFR 0.152.
 */
package org.appng.cli.commands.permission;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.List;
import org.appng.api.BusinessException;
import org.appng.cli.CliEnvironment;
import org.appng.cli.ExecutableCliCommand;

@Parameters(commandDescription="Removes one ore more permissions from a role.")
public class RemovePermission
implements ExecutableCliCommand {
    @Parameter(names={"-a"}, required=true, description="The application name.")
    private String applicationName;
    @Parameter(names={"-r"}, required=true, description="The role name.")
    private String roleName;
    @Parameter(names={"-n"}, required=true, variableArity=true, description="The permission(s) to remove, multiple values can be provided (separated by space).")
    private List<String> permissionNames;

    public RemovePermission() {
    }

    protected RemovePermission(String applicationName, String roleName, List<String> permissionNames) {
        this.applicationName = applicationName;
        this.roleName = roleName;
        this.permissionNames = permissionNames;
    }

    @Override
    public void execute(CliEnvironment cle) throws BusinessException {
        cle.getCoreService().removePermissions(this.applicationName, this.roleName, this.permissionNames);
    }
}

