/*
 * Decompiled with CFR 0.152.
 */
package org.appng.cli.commands.heartbeat;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpSession;
import org.appng.api.BusinessException;
import org.appng.api.Environment;
import org.appng.api.InvalidConfigurationException;
import org.appng.api.Scope;
import org.appng.api.messaging.Event;
import org.appng.api.messaging.EventHandler;
import org.appng.api.messaging.Messaging;
import org.appng.api.messaging.Sender;
import org.appng.api.model.Site;
import org.appng.api.model.Subject;
import org.appng.api.support.SiteClassLoader;
import org.appng.cli.CliEnvironment;
import org.appng.cli.ExecutableCliCommand;
import org.appng.core.domain.SiteImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parameters(commandDescription="Sends and receives a heartbeat using the configured messaging settings.")
public class HeartBeat
implements ExecutableCliCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeartBeat.class);
    @Parameter(names={"-i"}, description="The interval of the heartbeat in milliseconds.")
    private int interval = 1000;
    @Parameter(names={"-s"}, description="The site name for the heartbeat event.")
    private String site = "appng";
    @Parameter(names={"-n"}, description="The node id for the events to be send. Default: System.getProperty(\"appng.node.id\")")
    private String nodeId = System.getProperty("appng.node.id");

    @Override
    public void execute(CliEnvironment cle) throws BusinessException {
        ThreadFactoryBuilder tfb = new ThreadFactoryBuilder();
        ThreadFactory threadFactory = tfb.setDaemon(true).setNameFormat("appng-heartbeat").build();
        ExecutorService executor = Executors.newSingleThreadExecutor(threadFactory);
        if (null == this.nodeId) {
            try {
                this.nodeId = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                this.nodeId = "appng-heartbeat";
            }
        }
        PlatformEnv env = new PlatformEnv();
        EventHandler<HeartBeatEvent> heartBeatHandler = new EventHandler<HeartBeatEvent>(){

            public void onEvent(HeartBeatEvent event, Environment environment, Site site) throws InvalidConfigurationException, BusinessException {
                LOGGER.info("received {}", (Object)event);
                event.perform(environment, site);
            }

            public Class<HeartBeatEvent> getEventClass() {
                return HeartBeatEvent.class;
            }
        };
        EventHandler<Event> loggingHandler = new EventHandler<Event>(){

            public void onEvent(Event event, Environment environment, Site site) throws InvalidConfigurationException, BusinessException {
                LOGGER.info("received {}", (Object)event);
            }

            public Class<Event> getEventClass() {
                return Event.class;
            }
        };
        env.setAttribute(Scope.PLATFORM, "platformConfig", cle.getPlatformConfig());
        HashMap<String, SiteImpl> siteMap = new HashMap<String, SiteImpl>();
        List sites = cle.getCoreService().getSites();
        for (SiteImpl site : sites) {
            site.setSiteClassLoader(new SiteClassLoader(site.getName()));
            siteMap.put(site.getName(), site);
        }
        env.setAttribute(Scope.PLATFORM, "sites", siteMap);
        Sender sender = Messaging.createMessageSender((Environment)env, (ExecutorService)executor, (String)this.nodeId, (EventHandler)loggingHandler, Arrays.asList(heartBeatHandler));
        LOGGER.debug("created {}", (Object)sender);
        while (true) {
            sender.send((Event)new HeartBeatEvent(this.site));
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public static class HeartBeatEvent
    extends Event
    implements Serializable {
        public HeartBeatEvent(String site) {
            super(site);
        }

        public void perform(Environment environment, Site site) throws InvalidConfigurationException, BusinessException {
            LOGGER.info("still beating!");
        }
    }

    class PlatformEnv
    implements Environment {
        private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();

        PlatformEnv() {
        }

        private boolean isPlatformScope(Scope scope) {
            boolean isPlatformScope = Scope.PLATFORM.equals((Object)scope);
            return isPlatformScope;
        }

        public void setAttribute(Scope scope, String name, Object value) {
            if (this.isPlatformScope(scope)) {
                this.attributes.put(name, value);
            }
        }

        public <T> T getAttribute(Scope scope, String name) {
            if (this.isPlatformScope(scope)) {
                return (T)this.attributes.get(name);
            }
            return null;
        }

        public <T> T removeAttribute(Scope scope, String name) {
            if (this.isPlatformScope(scope)) {
                return (T)this.attributes.remove(name);
            }
            return null;
        }

        public String getAttributeAsString(Scope scope, String name) {
            Object attrib = this.getAttribute(scope, name);
            if (attrib != null) {
                return attrib.toString();
            }
            return null;
        }

        public Set<String> keySet(Scope scope) {
            if (this.isPlatformScope(scope)) {
                return this.attributes.keySet();
            }
            return null;
        }

        public Subject getSubject() {
            return null;
        }

        public Locale getLocale() {
            return Locale.getDefault();
        }

        public TimeZone getTimeZone() {
            return TimeZone.getDefault();
        }

        public boolean isSubjectAuthenticated() {
            return false;
        }

        public void init(ServletContext context, HttpSession session, ServletRequest request, ServletResponse response, String host) {
        }
    }
}

