/*
 * Decompiled with CFR 0.152.
 */
package org.appng.cli;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.appng.cli.CliBootstrap;
import org.appng.cli.CliBootstrapEnvironment;
import org.appng.cli.CliCore;
import org.appng.tools.os.OperatingSystem;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class CliShell {
    public static void main(String[] args) throws Exception {
        if (!OperatingSystem.isWindows()) {
            System.out.println("\u001b[31m");
        }
        ClassLoader classLoader = CliShell.class.getClassLoader();
        List logo = IOUtils.readLines((InputStream)classLoader.getResourceAsStream("cli-shell.txt"), (Charset)StandardCharsets.UTF_8);
        logo.forEach(l -> System.out.println((String)l));
        CliBootstrapEnvironment env = new CliBootstrapEnvironment();
        File platformRootPath = null;
        String appngHome = null;
        appngHome = args.length == 1 ? args[0] : System.getProperty("APPNG_HOME");
        if (null != appngHome) {
            platformRootPath = new File(appngHome).getAbsoluteFile();
        }
        if (null == platformRootPath || !platformRootPath.exists()) {
            platformRootPath = CliBootstrap.getPlatformRootPath(env);
        }
        final Properties cliConfig = CliBootstrap.getCliConfig(env, true, platformRootPath);
        FutureTask<ApplicationContext> futureTask = new FutureTask<ApplicationContext>(new Callable<ApplicationContext>(){

            @Override
            public ConfigurableApplicationContext call() throws Exception {
                return CliBootstrap.getContext(cliConfig, "cliContext.xml");
            }
        });
        System.out.print("Loading appNG shell");
        Executors.newFixedThreadPool(1).execute(futureTask);
        long start = System.currentTimeMillis();
        while (!futureTask.isDone()) {
            System.out.print(".");
            Thread.sleep(500L);
        }
        long stop = System.currentTimeMillis();
        System.out.println("done! duration: " + (stop - start) + "ms");
        ApplicationContext context = futureTask.get(1L, TimeUnit.MINUTES);
        CliCore cliCore = new CliCore();
        cliCore.setContext(context);
        BufferedReader console = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            System.out.print("appng> ");
            String commandLine = console.readLine();
            if ("exit".equals(StringUtils.trimToEmpty((String)commandLine))) {
                System.out.println("bye");
                System.exit(0);
            }
            if (null == StringUtils.trimToNull((String)commandLine) || !cliCore.processCommand(commandLine.split(" "))) continue;
            cliCore.perform(cliConfig);
        }
    }
}

