/*
 * Decompiled with CFR 0.152.
 */
package org.appng.cli;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.BindException;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.appng.cli.CliBootstrapEnvironment;
import org.appng.cli.CliCore;
import org.appng.core.service.HsqlStarter;
import org.hsqldb.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.util.StopWatch;

public class CliBootstrap {
    private static final Logger LOGGER = LoggerFactory.getLogger(CliBootstrap.class);
    public static String CURRENT_COMMAND;
    public static final String APPNG_HOME = "APPNG_HOME";
    static final String CLI_CONTEXT_XML = "cliContext.xml";

    public static void main(String[] args) throws IOException {
        int status = CliBootstrap.run(args);
        System.exit(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int run(String[] args) throws IOException {
        StopWatch cliWatch = new StopWatch("cli");
        cliWatch.start();
        CliCore cliCore = new CliCore();
        if (cliCore.processCommand(args)) {
            try {
                boolean serverStarted;
                Properties cliConfig;
                Server hsqlServer;
                CURRENT_COMMAND = StringUtils.join((Object[])args, (String)" ");
                CliBootstrapEnvironment env = new CliBootstrapEnvironment();
                File platformRootPath = null;
                String appngHome = System.getProperty(APPNG_HOME);
                if (null != appngHome) {
                    platformRootPath = new File(appngHome).getAbsoluteFile();
                }
                if (null == platformRootPath || !platformRootPath.exists()) {
                    platformRootPath = CliBootstrap.getPlatformRootPath(env);
                    LOGGER.info("{}: {}", (Object)APPNG_HOME, (Object)platformRootPath);
                }
                boolean isHsql = null != (hsqlServer = HsqlStarter.startHsql((Properties)(cliConfig = CliBootstrap.getCliConfig(env, true, platformRootPath)), (String)platformRootPath.getAbsolutePath()));
                boolean bl = serverStarted = isHsql && 1 == hsqlServer.getState();
                if (isHsql && !serverStarted) {
                    if (hsqlServer.getServerError().getClass().isAssignableFrom(BindException.class)) {
                        LOGGER.info("HSQL Server {} already running on port {}", (Object)hsqlServer.getProductVersion(), (Object)hsqlServer.getPort());
                    } else {
                        LOGGER.error(String.format("Failed to start HSQL Server %s on port %s", hsqlServer.getProductVersion(), hsqlServer.getPort()), hsqlServer.getServerError());
                        int n = 9;
                        return n;
                    }
                }
                try {
                    ConfigurableApplicationContext context = CliBootstrap.getContext(cliConfig, CLI_CONTEXT_XML);
                    cliCore.setContext((ApplicationContext)context);
                    cliCore.perform(cliConfig);
                    cliWatch.stop();
                    LOGGER.info("duration: {}ms", (Object)cliWatch.getTotalTimeMillis());
                    context.close();
                    if (serverStarted) {
                        HsqlStarter.shutdown((Server)hsqlServer);
                    } else {
                        LOGGER.info("HSQL server was already running, shutdown not required.");
                    }
                }
                catch (BeansException e) {
                    cliCore.logError("error while building context, see logs for details.");
                    LOGGER.error("error while building context", (Throwable)e);
                    int n = 10;
                    CURRENT_COMMAND = null;
                    return n;
                }
            }
            finally {
                CURRENT_COMMAND = null;
            }
        }
        return cliCore.getStatus();
    }

    static ConfigurableApplicationContext getContext(Properties config, String location) throws BeansException {
        PropertySourcesPlaceholderConfigurer appNGConfigurer = new PropertySourcesPlaceholderConfigurer();
        appNGConfigurer.setProperties(config);
        ClassPathXmlApplicationContext platformContext = new ClassPathXmlApplicationContext(new String[]{location}, false);
        platformContext.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)appNGConfigurer);
        platformContext.refresh();
        return platformContext;
    }

    private static File checkFile(String name, File file, boolean isDirectory) {
        if (null == file) {
            throw new IllegalArgumentException(name + " is not defined!");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("The path specified in " + name + " does not exist: " + file.getAbsolutePath());
        }
        if (isDirectory && !file.isDirectory()) {
            throw new IllegalArgumentException("The path specified in " + name + " must point to a directory: " + file.getAbsolutePath());
        }
        if (!isDirectory && !file.isFile()) {
            throw new IllegalArgumentException("The path specified in " + name + " must point to a file: " + file.getAbsolutePath());
        }
        return file;
    }

    static Properties getCliConfig(CliBootstrapEnvironment env, boolean logInfo, File platformRootPath) throws FileNotFoundException, IOException {
        String appngData = System.getProperty("appngData");
        File configFile = StringUtils.isBlank((CharSequence)appngData) ? new File(platformRootPath, "/WEB-INF/conf/appNG.properties") : new File(appngData, "/conf/appNG.properties");
        File properties = env.getAbsoluteFile(configFile);
        if (properties.exists()) {
            if (logInfo) {
                LOGGER.info("Using configuration file: {}", (Object)properties.getAbsolutePath());
            }
            Properties config = new Properties();
            config.load(new FileReader(properties));
            config.setProperty("platformRootPath", platformRootPath.getAbsolutePath());
            config.put("database.type", config.getProperty("database.type").toUpperCase());
            return config;
        }
        throw new FileNotFoundException("Configuration file not found: " + properties.getAbsolutePath());
    }

    static File getPlatformRootPath(CliBootstrapEnvironment env) {
        File appngHome = env.getFileFromEnv(APPNG_HOME);
        return CliBootstrap.checkFile(APPNG_HOME, appngHome, true);
    }
}

