/*
 * Decompiled with CFR 0.152.
 */
package org.appng.cli.prettytable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.appng.api.BusinessException;
import org.appng.cli.prettytable.TableColumn;
import org.appng.cli.prettytable.TableRow;

public class PrettyTable {
    private static final int CELL_MARGIN = 1;
    private static final String NL = "\n";
    private static final String TAB = "\t";
    private static final char SPACE = ' ';
    private static final String VERTICAL_BORDER = "|";
    private static final char DOUBLE_LINE = '=';
    private static final char SINGLE_LINE = '-';
    private List<TableColumn> columns = new ArrayList<TableColumn>();
    private List<TableRow> rows = new ArrayList<TableRow>();
    private Map<String, TableColumn> columnMap = new HashMap<String, TableColumn>();
    private int tableWidth = 0;

    public void addColumn(String name) {
        this.addColumn(name, false);
    }

    public void addColumn(String name, boolean isVerbose) {
        TableColumn col = new TableColumn(name, isVerbose, this.columns.size());
        this.columns.add(col);
        this.columnMap.put(name, col);
    }

    public void addRow(Object ... values) throws BusinessException {
        if (values.length != this.columns.size()) {
            throw new BusinessException("Number of header columns (" + this.columns.size() + ") is not equal to number of row columns (" + values.length + ")");
        }
        this.rows.add(new TableRow(this.columns, values));
    }

    public String render(boolean tabbedValues, boolean beVerbose) {
        boolean withBorders = !tabbedValues;
        this.tableWidth = 0;
        StringBuilder builder = new StringBuilder();
        builder = withBorders ? builder.append(VERTICAL_BORDER) : builder;
        int noOfColumns = 0;
        for (TableColumn column : this.columns) {
            String col = column.render(withBorders, beVerbose);
            StringBuilder stringBuilder = builder = null != col ? builder.append(col) : builder;
            if (!column.isVerbose() || beVerbose) {
                this.tableWidth += column.getCellWidth();
                ++noOfColumns;
            }
            if (withBorders || !column.equals(this.columns.get(this.columns.size() - 1))) continue;
            builder.deleteCharAt(builder.length() - 1);
        }
        this.tableWidth += (noOfColumns + 1) * VERTICAL_BORDER.length() + 1 * noOfColumns * 2;
        builder = builder.insert(0, this.newLine(withBorders, '='));
        builder.append((CharSequence)this.newLine(withBorders, '='));
        for (TableRow row : this.rows) {
            builder = withBorders ? builder.append(VERTICAL_BORDER) : builder;
            builder.append((CharSequence)row.render(this.columns, withBorders, beVerbose));
            builder.append((CharSequence)this.newLine(withBorders, '-'));
        }
        return builder.toString();
    }

    private StringBuilder newLine(boolean withBorders, char c) {
        if (withBorders) {
            return this.newLine(c);
        }
        return this.newLine();
    }

    private StringBuilder newLine(char lineChar) {
        return this.newLine().append((CharSequence)PrettyTable.addSpace(this.tableWidth, lineChar)).append(NL);
    }

    private StringBuilder newLine() {
        return new StringBuilder().append(NL);
    }

    static String bordered(String n, int columnWidth) {
        int space = columnWidth - n.length();
        return PrettyTable.addSpace(1, ' ') + n + PrettyTable.addSpace(space, ' ') + PrettyTable.addSpace(1, ' ') + VERTICAL_BORDER;
    }

    static String tabbed(String n) {
        return n + TAB;
    }

    private static StringBuilder addSpace(int space, char c) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < space; ++i) {
            builder.append(c);
        }
        return builder;
    }

    public List<TableRow> getRows() {
        return Collections.unmodifiableList(this.rows);
    }

    public int getColumnIndex(String id) {
        return this.columns.indexOf(this.columnMap.get(id));
    }
}

