/*
 * Decompiled with CFR 0.152.
 */
package org.appng.cli.commands.subject;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.appng.api.BusinessException;
import org.appng.api.model.AuthSubject;
import org.appng.api.model.Properties;
import org.appng.api.model.UserType;
import org.appng.cli.CliEnvironment;
import org.appng.cli.ExecutableCliCommand;
import org.appng.core.domain.SubjectImpl;
import org.appng.core.security.DefaultPasswordPolicy;
import org.appng.core.security.PasswordHandler;

@Parameters(commandDescription="Creates a subject.")
public class CreateSubject
implements ExecutableCliCommand {
    @Parameter(names={"-u"}, required=true, description="The user name.")
    private String loginName;
    @Parameter(names={"-n"}, required=true, description="The real name.")
    private String realName;
    @Parameter(names={"-e"}, required=true, description="The e-mail address.")
    private String email;
    @Parameter(names={"-p"}, required=false, description="The password, mandatory for type LOCAL_USER.")
    private String password;
    @Parameter(names={"-l"}, required=false, description="GUI language of the user.")
    private String language = "de";
    @Parameter(names={"-d"}, required=false, description="Description of the user.")
    private String description = "";
    @Parameter(names={"-t"}, required=false, description="The type of the user.")
    private UserType type = UserType.LOCAL_USER;

    public CreateSubject() {
    }

    CreateSubject(String loginName, String realName, String email, String password, String language, String description, UserType type) {
        this.loginName = loginName;
        this.realName = realName;
        this.email = email;
        this.password = password;
        this.language = language;
        this.description = description;
        this.type = type;
    }

    @Override
    public void execute(CliEnvironment cle) throws BusinessException {
        SubjectImpl subject = new SubjectImpl();
        if (UserType.LOCAL_USER.equals((Object)this.type)) {
            String errorMessageKey;
            if (StringUtils.isBlank((CharSequence)this.password)) {
                throw new BusinessException(String.format("-p is mandatory for type %s", this.type.name()));
            }
            Properties platformConfig = cle.getPlatformConfig();
            String regEx = platformConfig.getString("passwordPolicyRegEx");
            DefaultPasswordPolicy passwordPolicy = new DefaultPasswordPolicy(regEx, errorMessageKey = platformConfig.getString("passwordPolicyErrorMessageKey"));
            if (!passwordPolicy.isValidPassword(this.password.toCharArray())) {
                String errorMessage = cle.getMessageSource().getMessage(errorMessageKey, null, Locale.ENGLISH);
                throw new BusinessException(errorMessage);
            }
            PasswordHandler passwordHandler = cle.getCoreService().getDefaultPasswordHandler((AuthSubject)subject);
            passwordHandler.savePassword(this.password);
        } else if (StringUtils.isNotBlank((CharSequence)this.password)) {
            throw new BusinessException(String.format("-p is not allowed for type %s", this.type.name()));
        }
        if (null != cle.getCoreService().getSubjectByName(this.loginName, false)) {
            throw new BusinessException(String.format("Subject with name '%s' already exists.", this.loginName));
        }
        subject.setName(this.loginName);
        subject.setRealname(this.realName);
        subject.setEmail(this.email);
        subject.setLanguage(this.language);
        subject.setDescription(this.description);
        subject.setUserType(this.type);
        cle.getCoreService().createSubject(subject);
    }
}

