/*
 * Decompiled with CFR 0.152.
 */
package org.appng.cli.commands.permission;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.commons.lang3.StringUtils;
import org.appng.api.BusinessException;
import org.appng.api.model.Nameable;
import org.appng.api.model.Permission;
import org.appng.api.model.Role;
import org.appng.cli.CliEnvironment;
import org.appng.cli.ExecutableCliCommand;
import org.appng.cli.commands.CommandList;
import org.appng.core.model.AccessibleApplication;

@Parameters(commandDescription="Lists the available permissions for a application/a role of a application.")
public class ListPermissions
extends CommandList
implements ExecutableCliCommand {
    @Parameter(names={"-a"}, required=true, description="The application name.")
    private String applicationName;
    @Parameter(names={"-r"}, required=false, description="The role name.")
    private String roleName;

    public ListPermissions() {
    }

    protected ListPermissions(String applicationName, String roleName) {
        this.applicationName = applicationName;
        this.roleName = roleName;
    }

    @Override
    public void execute(CliEnvironment cle) throws BusinessException {
        ArrayList permissions = null;
        if (StringUtils.isNotEmpty((CharSequence)this.applicationName)) {
            AccessibleApplication application = cle.getCoreService().findApplicationByName(this.applicationName);
            if (null != application) {
                if (StringUtils.isNotEmpty((CharSequence)this.roleName)) {
                    Role role = cle.getCoreService().getApplicationRoleForApplication((Integer)application.getId(), this.roleName);
                    if (null == role) {
                        throw new BusinessException("no such role: " + this.roleName);
                    }
                    permissions = new ArrayList(role.getPermissions());
                } else {
                    permissions = cle.getCoreService().getPermissionsForApplication((Integer)application.getId());
                }
                Collections.sort(permissions, new Comparator<Nameable>(){

                    @Override
                    public int compare(Nameable n1, Nameable n2) {
                        return n1.getName().compareTo(n2.getName());
                    }
                });
                this.prettyTable.addColumn("ID");
                this.prettyTable.addColumn("Name");
                this.prettyTable.addColumn("Description");
                for (Permission permission : permissions) {
                    this.prettyTable.addRow(permission.getId(), permission.getName(), permission.getDescription());
                }
                cle.setResult(this.renderTable());
            } else {
                throw new BusinessException("no such application: " + this.applicationName);
            }
        }
    }
}

