/*
 * Decompiled with CFR 0.152.
 */
package org.appng.cli.commands.group;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.List;
import org.appng.api.BusinessException;
import org.appng.cli.CliEnvironment;
import org.appng.cli.ExecutableCliCommand;

@Parameters(commandDescription="Adds a group to a subject.")
public class AddGroup
implements ExecutableCliCommand {
    @Parameter(names={"-u"}, required=true, description="The user name of the subject.")
    private String loginName;
    @Parameter(names={"-g"}, required=true, variableArity=true, description="The group name. Multiple values can be provided (separated by space).")
    private List<String> groupName;
    @Parameter(names={"-c"}, required=false, description="Clear existing groups of the subject.")
    private boolean clear;

    public AddGroup() {
    }

    AddGroup(String loginName, List<String> groupNames) {
        this.loginName = loginName;
        this.groupName = groupNames;
    }

    @Override
    public void execute(CliEnvironment cle) throws BusinessException {
        cle.getCoreService().addGroupsToSubject(this.loginName, this.groupName, this.clear);
    }
}

