/*
 * Decompiled with CFR 0.152.
 */
package org.appng.cli.commands.applicationrole;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.appng.api.BusinessException;
import org.appng.api.model.Role;
import org.appng.cli.CliEnvironment;
import org.appng.cli.ExecutableCliCommand;
import org.appng.cli.commands.CommandList;
import org.appng.core.model.AccessibleApplication;

@Parameters(commandDescription="Lists the available application roles for a application.")
public class ListRoles
extends CommandList
implements ExecutableCliCommand {
    @Parameter(names={"-a"}, required=false, description="The application name.")
    private String applicationName;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(CliEnvironment cle) throws BusinessException {
        List applicationRoles = null;
        if (StringUtils.isNotEmpty((CharSequence)this.applicationName)) {
            AccessibleApplication application = cle.getCoreService().findApplicationByName(this.applicationName);
            if (null == application) throw new BusinessException("no such application: " + this.applicationName);
            applicationRoles = cle.getCoreService().getApplicationRolesForApplication((Integer)application.getId());
        } else {
            applicationRoles = cle.getCoreService().getApplicationRoles();
        }
        if (null == applicationRoles) return;
        this.prettyTable.addColumn("ID");
        this.prettyTable.addColumn("Application");
        this.prettyTable.addColumn("Name");
        this.prettyTable.addColumn("Description", true);
        for (Role applicationRole : applicationRoles) {
            this.prettyTable.addRow(applicationRole.getId(), applicationRole.getApplication().getName(), applicationRole.getName(), applicationRole.getDescription());
        }
        cle.setResult(this.renderTable());
    }
}

