/*
 * Decompiled with CFR 0.152.
 */
package org.appng.cli.commands.subject;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.Locale;
import org.appng.api.BusinessException;
import org.appng.api.model.AuthSubject;
import org.appng.api.model.Properties;
import org.appng.api.model.UserType;
import org.appng.cli.CliEnvironment;
import org.appng.cli.ExecutableCliCommand;
import org.appng.core.domain.SubjectImpl;
import org.appng.core.security.DefaultPasswordPolicy;
import org.appng.core.security.PasswordHandler;
import org.springframework.context.MessageSource;

@Parameters(commandDescription="Creates a subject.")
public class CreateSubject
implements ExecutableCliCommand {
    @Parameter(names={"-u"}, required=true, description="The user name.")
    private String loginName;
    @Parameter(names={"-n"}, required=true, description="The real name.")
    private String realName;
    @Parameter(names={"-e"}, required=true, description="The e-mail address.")
    private String email;
    @Parameter(names={"-p"}, required=true, description="The password.")
    private String password;
    @Parameter(names={"-l"}, required=false, description="GUI language of the user.")
    private String language = "de";
    @Parameter(names={"-d"}, required=false, description="Description of the user.")
    private String description = "";

    public CreateSubject() {
    }

    public CreateSubject(String loginName, String realName, String email, String password, String language, String description) {
        this.loginName = loginName;
        this.realName = realName;
        this.email = email;
        this.password = password;
        this.language = language;
        this.description = description;
    }

    @Override
    public void execute(CliEnvironment cle) throws BusinessException {
        String errorMessageKey;
        Properties platformConfig = cle.getPlatformConfig();
        String regEx = platformConfig.getString("passwordPolicyRegEx");
        DefaultPasswordPolicy passwordPolicy = new DefaultPasswordPolicy(regEx, errorMessageKey = platformConfig.getString("passwordPolicyErrorMessageKey"));
        if (!passwordPolicy.isValidPassword(this.password.toCharArray())) {
            MessageSource messageSource = cle.getMessageSource();
            String errorMessage = messageSource.getMessage(errorMessageKey, null, Locale.ENGLISH);
            throw new BusinessException(errorMessage);
        }
        SubjectImpl subject = new SubjectImpl();
        subject.setName(this.loginName);
        subject.setRealname(this.realName);
        subject.setEmail(this.email);
        subject.setLanguage(this.language);
        subject.setDescription(this.description);
        subject.setUserType(UserType.LOCAL_USER);
        PasswordHandler passwordHandler = cle.getCoreService().getDefaultPasswordHandler((AuthSubject)subject);
        passwordHandler.savePassword(this.password);
        cle.getCoreService().createSubject(subject);
    }
}

