/*
 * Decompiled with CFR 0.152.
 */
package org.appng.cli.commands.site;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.IOUtils;
import org.appng.api.BusinessException;
import org.appng.cli.CliEnvironment;
import org.appng.cli.ExecutableCliCommand;
import org.appng.cli.NoSuchSiteException;
import org.appng.core.domain.SiteImpl;
import org.appng.xml.MarshallService;
import org.appng.xml.platform.Platform;

@Parameters(commandDescription="Checks whether a site is running.")
public class CheckSiteRunning
implements ExecutableCliCommand {
    static final String XML_PREFIX = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final int TIMEOUT = 10000;
    @Parameter(names={"-n"}, required=true, description="The site name.")
    private String name;
    protected int responseCode = -1;
    private String version;
    private boolean running;

    public CheckSiteRunning() {
    }

    public CheckSiteRunning(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    String getContent(String uri) {
        String string;
        InputStream is = null;
        HttpURLConnection connection = null;
        try {
            URL url = new URL(uri);
            connection = (HttpURLConnection)url.openConnection();
            connection.setInstanceFollowRedirects(false);
            connection.setConnectTimeout(10000);
            this.responseCode = connection.getResponseCode();
            is = connection.getInputStream();
            string = IOUtils.toString((InputStream)is, (Charset)Charset.defaultCharset());
        }
        catch (IOException iOException) {
            IOUtils.closeQuietly(is);
            if (null != connection) {
                connection.disconnect();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                if (null != connection) {
                    connection.disconnect();
                }
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        if (null != connection) {
            connection.disconnect();
        }
        return string;
        return null;
    }

    @Override
    public void execute(CliEnvironment cle) throws BusinessException {
        SiteImpl site = cle.getCoreService().getSiteByName(this.name);
        if (null == site) {
            throw new NoSuchSiteException(this.name);
        }
        String adminPath = site.getProperties().getString("manager-path");
        String domain = site.getDomain();
        StringBuilder sb = new StringBuilder();
        if (!domain.startsWith("http://") && !domain.startsWith("https://")) {
            sb.append("http://");
        }
        sb.append(domain);
        sb.append(adminPath);
        sb.append("/");
        sb.append(site.getName());
        String siteUri = sb.toString();
        sb.append("?xsl=false");
        try {
            String uri = sb.toString();
            String content = this.getContent(uri);
            if (null != content && content.startsWith(XML_PREFIX)) {
                Platform platform = (Platform)MarshallService.getMarshallService().unmarshall(content, Platform.class);
                this.version = platform.getVersion();
                this.running = true;
                CliEnvironment.out.println("site '" + this.name + "' is running at " + siteUri + " with appNG version " + this.version);
            } else {
                String message = "site '" + this.name + "' is NOT running at " + siteUri;
                if (this.responseCode > 0) {
                    message = message + " HTTP response code: " + this.responseCode;
                }
                CliEnvironment.out.println(message);
            }
        }
        catch (JAXBException e) {
            throw new BusinessException("failed to parse response from " + siteUri, (Throwable)e);
        }
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isRunning() {
        return this.running;
    }
}

