/*
 * Decompiled with CFR 0.152.
 */
package org.appng.cli.commands.repository;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.appng.api.BusinessException;
import org.appng.cli.CliEnvironment;
import org.appng.cli.ExecutableCliCommand;
import org.appng.cli.NoSuchRepositoryException;
import org.appng.core.model.Repository;
import org.appng.core.model.RepositoryType;

@Parameters(commandDescription="Deletes a repository.")
public class DeleteRepository
implements ExecutableCliCommand {
    @Parameter(names={"-n"}, required=true, description="The repository name.")
    private String repositoryName;
    @Parameter(names={"-r"}, required=false, description="Remove the directory and its files (only LOCAL repositories).")
    private boolean deleteDirectory;

    public DeleteRepository() {
    }

    DeleteRepository(String repositoryName, boolean deleteDirectory) {
        this.repositoryName = repositoryName;
        this.deleteDirectory = deleteDirectory;
    }

    @Override
    public void execute(CliEnvironment cle) throws BusinessException {
        Repository repository = cle.getCoreService().getApplicationRepositoryByName(this.repositoryName);
        if (null != repository) {
            if (this.deleteDirectory && RepositoryType.LOCAL.equals((Object)repository.getRepositoryType())) {
                try {
                    FileUtils.forceDelete((File)new File(repository.getUri()));
                }
                catch (IOException e) {
                    throw new BusinessException("Unable to delete repository: " + repository.getUri(), (Throwable)e);
                }
            }
            cle.getCoreService().deleteApplicationRepository(repository);
        } else if (null == repository) {
            throw new NoSuchRepositoryException(this.repositoryName);
        }
    }
}

