/*
 * Decompiled with CFR 0.152.
 */
package org.appng.cli.commands.application;

import org.appng.api.BusinessException;
import org.appng.api.model.Application;
import org.appng.api.model.Nameable;
import org.appng.cli.CliEnvironment;
import org.appng.cli.NoSuchSiteException;
import org.appng.core.domain.SiteImpl;
import org.appng.core.model.AccessibleApplication;
import org.appng.core.model.CacheProvider;

public class BaseApplication {
    void execute(CliEnvironment cle, String siteName, String applicationName, Mode mode) throws BusinessException {
        SiteImpl site = cle.getCoreService().getSiteByName(siteName);
        if (null == site) {
            throw new NoSuchSiteException(siteName);
        }
        AccessibleApplication application = cle.getCoreService().findApplicationByName(applicationName);
        if (null == application) {
            throw new BusinessException("Application not found: " + applicationName);
        }
        boolean isAssigned = site.getApplications().contains(application);
        if (Mode.LINK.equals((Object)mode) && !isAssigned) {
            cle.getCoreService().assignApplicationToSite(site, (Application)application, true);
            new CacheProvider(cle.getPlatformConfig()).getPlatformCache((Nameable)site, (Nameable)application);
        } else if (Mode.UNLINK.equals((Object)mode) && isAssigned) {
            cle.getCoreService().unlinkApplicationFromSite(site.getId(), (Integer)application.getId());
        } else {
            throw new BusinessException("Application " + application.getName() + " with id " + application.getId() + " is " + mode.word + " linked to Site " + site.getName() + " with id " + site.getId());
        }
    }

    public static enum Mode {
        LINK("already"),
        UNLINK("not");

        private String word;

        private Mode(String word) {
            this.word = word;
        }
    }
}

