/*
 * Decompiled with CFR 0.152.
 */
package org.appng.cli.commands.template;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import org.appng.api.BusinessException;
import org.appng.cli.CliEnvironment;
import org.appng.cli.ExecutableCliCommand;
import org.appng.core.service.CoreService;

@Parameters(commandDescription="Deletes a template.")
public class DeleteTemplate
implements ExecutableCliCommand {
    @Parameter(names={"-n"}, required=true, description="The name of the template.")
    private String templateName;

    @Override
    public void execute(CliEnvironment cle) throws BusinessException {
        CoreService coreService = cle.getCoreService();
        Integer state = coreService.deleteTemplate(this.templateName);
        switch (state) {
            case 0: {
                cle.setResult(this.templateName + " deleted.");
                break;
            }
            case -1: {
                cle.setResult("no such template: " + this.templateName);
                break;
            }
            case -2: {
                cle.setResult(this.templateName + " is in use and can not be deleted.");
            }
        }
    }
}

