/*
 * Decompiled with CFR 0.152.
 */
package org.appng.cli.commands.site;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.appng.api.BusinessException;
import org.appng.cli.CliEnvironment;
import org.appng.cli.ExecutableCliCommand;
import org.appng.cli.commands.site.CheckSiteRunning;
import org.appng.core.domain.SiteImpl;

@Parameters(commandDescription="Reloads a site (site property supportReloadFile must be true).")
public class ReloadSite
implements ExecutableCliCommand {
    @Parameter(names={"-n"}, required=true, description="The site name.")
    private String siteName;

    public ReloadSite() {
    }

    ReloadSite(String siteName) {
        this.siteName = siteName;
    }

    @Override
    public void execute(CliEnvironment cle) throws BusinessException {
        CheckSiteRunning checkSiteRunning = new CheckSiteRunning(this.siteName);
        checkSiteRunning.execute(cle);
        if (!checkSiteRunning.isRunning()) {
            throw new BusinessException("The site '" + this.siteName + "' is currently not running and can not be reloaded.");
        }
        SiteImpl site = cle.getCoreService().getSiteByName(this.siteName);
        if (Boolean.TRUE.equals(site.getProperties().getBoolean("supportReloadFile"))) {
            String rootDir = site.getProperties().getString("siteRootDir");
            File reloadFile = new File(rootDir, ".reload");
            try {
                FileUtils.touch((File)reloadFile);
                CliEnvironment.out.println("Created reload marker " + reloadFile.getAbsolutePath());
            }
            catch (IOException e) {
                throw new BusinessException((Throwable)e);
            }
        } else {
            String notSupported = String.format("Site %s does not support this, set %s=true to enable this feature.", this.siteName, "supportReloadFile");
            CliEnvironment.out.println(notSupported);
        }
    }
}

