/*
 * Decompiled with CFR 0.152.
 */
package org.appng.cli.commands.site;

import com.beust.jcommander.Parameters;
import java.util.List;
import org.appng.api.BusinessException;
import org.appng.api.model.Site;
import org.appng.cli.CliEnvironment;
import org.appng.cli.ExecutableCliCommand;
import org.appng.cli.commands.CommandList;

@Parameters(commandDescription="Lists the available sites.")
public class ListSites
extends CommandList
implements ExecutableCliCommand {
    @Override
    public void execute(CliEnvironment cle) throws BusinessException {
        List sites = cle.getCoreService().getSites();
        if (null != sites) {
            this.prettyTable.addColumn("ID");
            this.prettyTable.addColumn("Name");
            this.prettyTable.addColumn("Host");
            this.prettyTable.addColumn("Domain");
            this.prettyTable.addColumn("Is active", true);
            for (Site site : sites) {
                this.prettyTable.addRow(site.getId(), site.getName(), site.getHost(), site.getDomain(), site.isActive());
            }
            cle.setResult(this.renderTable());
        }
    }
}

