/*
 * Decompiled with CFR 0.152.
 */
package org.appng.cli.commands.repository;

import com.beust.jcommander.Parameters;
import java.util.List;
import org.appng.api.BusinessException;
import org.appng.cli.CliEnvironment;
import org.appng.cli.ExecutableCliCommand;
import org.appng.cli.commands.CommandList;
import org.appng.core.model.Repository;

@Parameters(commandDescription="Lists the available repositories.")
public class ListRepositories
extends CommandList
implements ExecutableCliCommand {
    @Override
    public void execute(CliEnvironment cle) throws BusinessException {
        List repositories = cle.getCoreService().getApplicationRepositories();
        if (null != repositories) {
            this.prettyTable.addColumn("ID");
            this.prettyTable.addColumn("Name");
            this.prettyTable.addColumn("Type");
            this.prettyTable.addColumn("Mode", true);
            this.prettyTable.addColumn("URI");
            this.prettyTable.addColumn("Is active", true);
            this.prettyTable.addColumn("Description", true);
            for (Repository repository : repositories) {
                this.prettyTable.addRow(repository.getId(), repository.getName(), repository.getRepositoryType(), repository.getRepositoryMode(), repository.getUri(), repository.isActive(), repository.getDescription());
            }
            cle.setResult(this.renderTable());
        }
    }
}

