/*
 * Decompiled with CFR 0.152.
 */
package org.appng.cli.commands.permission;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.List;
import org.appng.api.BusinessException;
import org.appng.cli.CliEnvironment;
import org.appng.cli.ExecutableCliCommand;

@Parameters(commandDescription="Adds one ore more permissions to a role.")
public class AddPermission
implements ExecutableCliCommand {
    @Parameter(names={"-a"}, required=true, description="The application name.")
    private String applicationName;
    @Parameter(names={"-r"}, required=true, description="The role name.")
    private String roleName;
    @Parameter(names={"-n"}, required=true, variableArity=true, description="The permission(s) to add, multiple values can be provided (separated by space).")
    private List<String> permissionNames;

    public AddPermission() {
    }

    protected AddPermission(String applicationName, String roleName, List<String> permissionNames) {
        this.applicationName = applicationName;
        this.roleName = roleName;
        this.permissionNames = permissionNames;
    }

    @Override
    public void execute(CliEnvironment cle) throws BusinessException {
        cle.getCoreService().addPermissions(this.applicationName, this.roleName, this.permissionNames);
    }
}

