/*
 * Decompiled with CFR 0.152.
 */
package org.appng.cli;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import org.appng.cli.CliBootstrapEnvironment;
import org.appng.cli.CliCore;
import org.appng.core.service.HsqlStarter;
import org.hsqldb.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.util.StopWatch;

public class CliBootstrap {
    public static final String APPNG_HOME = "APPNG_HOME";
    private static final Logger LOG = LoggerFactory.getLogger(CliBootstrap.class);
    static final String CLI_CONTEXT_XML = "cliContext.xml";

    public static void main(String[] args) throws IOException {
        int status = CliBootstrap.run(args);
        System.exit(status);
    }

    public static int run(String[] args) throws IOException {
        StopWatch cliWatch = new StopWatch("cli");
        cliWatch.start();
        CliCore cliCore = new CliCore();
        if (cliCore.processCommand(args)) {
            CliBootstrapEnvironment env = new CliBootstrapEnvironment();
            File platformRootPath = null;
            String appngHome = System.getProperty(APPNG_HOME);
            if (null != appngHome) {
                platformRootPath = new File(appngHome).getAbsoluteFile();
            }
            if (null == platformRootPath || !platformRootPath.exists()) {
                platformRootPath = CliBootstrap.getPlatformRootPath(env);
                LOG.info("{}: {}", (Object)APPNG_HOME, (Object)platformRootPath);
            }
            Properties cliConfig = CliBootstrap.getCliConfig(env, true, platformRootPath);
            Server hsqlServer = HsqlStarter.startHsql((Properties)cliConfig, (String)platformRootPath.getAbsolutePath());
            try {
                ConfigurableApplicationContext context = CliBootstrap.getContext(cliConfig, CLI_CONTEXT_XML);
                cliCore.setContext((ApplicationContext)context);
                cliCore.perform(cliConfig);
                cliWatch.stop();
                LOG.info("duration: {}ms", (Object)cliWatch.getTotalTimeMillis());
                context.close();
                HsqlStarter.shutdown((Server)hsqlServer);
            }
            catch (BeansException e) {
                cliCore.logError("error while building context, see logs for details.");
                LOG.error("error while building context", (Throwable)e);
                return 10;
            }
        }
        return cliCore.getStatus();
    }

    static ConfigurableApplicationContext getContext(Properties config, String location) throws BeansException {
        PropertySourcesPlaceholderConfigurer appNGConfigurer = new PropertySourcesPlaceholderConfigurer();
        appNGConfigurer.setProperties(config);
        ClassPathXmlApplicationContext platformContext = new ClassPathXmlApplicationContext(new String[]{location}, false);
        platformContext.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)appNGConfigurer);
        platformContext.refresh();
        return platformContext;
    }

    private static File checkFile(String name, File file, boolean isDirectory) {
        if (null == file) {
            throw new IllegalArgumentException(name + " is not defined!");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("The path specified in " + name + " does not exist: " + file.getAbsolutePath());
        }
        if (isDirectory && !file.isDirectory()) {
            throw new IllegalArgumentException("The path specified in " + name + " must point to a directory: " + file.getAbsolutePath());
        }
        if (!isDirectory && !file.isFile()) {
            throw new IllegalArgumentException("The path specified in " + name + " must point to a file: " + file.getAbsolutePath());
        }
        return file;
    }

    static Properties getCliConfig(CliBootstrapEnvironment env, boolean logInfo, File platformRootPath) throws FileNotFoundException, IOException {
        Properties config = new Properties();
        File properties = env.getAbsoluteFile(new File(platformRootPath, "/WEB-INF/conf/appNG.properties"));
        if (properties.exists()) {
            if (logInfo) {
                LOG.info("Using configuration file: " + properties.getAbsolutePath());
            }
        } else {
            throw new FileNotFoundException("Configuration file not found: " + properties.getAbsolutePath());
        }
        config.load(new FileReader(properties));
        config.setProperty("platformRootPath", platformRootPath.getAbsolutePath());
        config.put("database.type", config.getProperty("database.type").toUpperCase());
        return config;
    }

    static File getPlatformRootPath(CliBootstrapEnvironment env) {
        File appngHome = env.getFileFromEnv(APPNG_HOME);
        return CliBootstrap.checkFile(APPNG_HOME, appngHome, true);
    }
}

