/*
 * Decompiled with CFR 0.152.
 */
package org.appng.cli.commands.template;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import org.appng.api.BusinessException;
import org.appng.api.model.Properties;
import org.appng.cli.CliEnvironment;
import org.appng.cli.ExecutableCliCommand;
import org.appng.cli.NoSuchRepositoryException;
import org.appng.core.model.Repository;
import org.appng.core.model.RepositoryCacheFactory;
import org.appng.core.service.CoreService;

@Parameters(commandDescription="Installs a template.")
public class InstallTemplate
implements ExecutableCliCommand {
    @Parameter(names={"-n"}, required=true, description="The name of the template.")
    private String templateName;
    @Parameter(names={"-v"}, required=true, description="The version of the template.")
    private String templateVersion;
    @Parameter(names={"-t"}, required=false, description="The timestamp of the template.")
    private String templateTimestamp;
    @Parameter(names={"-r"}, required=true, description="The name of the repository.")
    private String repositoryName;

    @Override
    public void execute(CliEnvironment cle) throws BusinessException {
        Repository repository = cle.getCoreService().getApplicationRepositoryByName(this.repositoryName);
        if (null == repository) {
            throw new NoSuchRepositoryException(this.repositoryName);
        }
        if (null == RepositoryCacheFactory.instance()) {
            RepositoryCacheFactory.init((Properties)cle.getPlatformConfig());
        }
        CoreService coreService = cle.getCoreService();
        coreService.provideTemplate((Integer)repository.getId(), this.templateName, this.templateVersion, this.templateTimestamp);
    }
}

