/*
 * Decompiled with CFR 0.152.
 */
package org.appng.cli.commands.site;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import org.appng.api.BusinessException;
import org.appng.api.FieldProcessor;
import org.appng.api.support.FieldProcessorImpl;
import org.appng.cli.CliEnvironment;
import org.appng.cli.ExecutableCliCommand;
import org.appng.cli.commands.site.CheckSiteRunning;

@Parameters(commandDescription="Deletes a site.")
public class DeleteSite
implements ExecutableCliCommand {
    @Parameter(names={"-n"}, required=true, description="The site name.")
    private String siteName;

    public DeleteSite() {
    }

    DeleteSite(String siteName) {
        this.siteName = siteName;
    }

    @Override
    public void execute(CliEnvironment cle) throws BusinessException {
        CheckSiteRunning checkSiteRunning = new CheckSiteRunning(this.siteName);
        checkSiteRunning.execute(cle);
        if (checkSiteRunning.isRunning()) {
            throw new BusinessException("The site '" + this.siteName + "' is currently running and can not be deleted.");
        }
        cle.getCoreService().deleteSite(this.siteName, (FieldProcessor)new FieldProcessorImpl(null));
    }
}

