/*
 * Decompiled with CFR 0.152.
 */
package org.appng.cli.commands.property;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import org.appng.api.BusinessException;
import org.appng.cli.CliEnvironment;
import org.appng.cli.ExecutableCliCommand;
import org.appng.cli.commands.property.PropertyHelper;
import org.appng.cli.validators.FileExists;
import org.appng.core.domain.PropertyImpl;

@Parameters(commandDescription="Updates a property.")
public class UpdateProperty
implements ExecutableCliCommand {
    @Parameter(names={"-n"}, required=true, description="The property name.")
    private String name;
    @Parameter(names={"-v"}, required=false, description="The property value. Mutually exclusive with -c.")
    private String value;
    @Parameter(names={"-c"}, required=false, description="The name of the file containing the clob value. Mutually exclusive with -v.", validateWith={FileExists.class})
    private String clob;

    public UpdateProperty() {
    }

    UpdateProperty(String name, String value, String clob) {
        this.name = name;
        this.value = value;
        this.clob = clob;
    }

    @Override
    public void execute(CliEnvironment cle) throws BusinessException {
        PropertyHelper.validate(this.value, this.clob);
        PropertyImpl property = cle.getCoreService().getProperty(this.name);
        if (null == property) {
            throw new BusinessException("No such property: " + this.name);
        }
        PropertyHelper.update(property, this.value, this.clob, false);
        cle.getCoreService().saveProperty(property);
    }
}

