/*
 * Decompiled with CFR 0.152.
 */
package org.appng.cli.commands.property;

import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.appng.api.BusinessException;
import org.appng.core.domain.PropertyImpl;

public class PropertyHelper {
    static void validate(String value, String clob) {
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{value, clob}) || StringUtils.isBlank((CharSequence)value) && StringUtils.isBlank((CharSequence)clob)) {
            throw new ParameterException("Use either -c or -v!");
        }
    }

    static void update(PropertyImpl property, String value, String clob, boolean isDefault) throws BusinessException {
        if (null != clob) {
            File path = new File(clob).getAbsoluteFile();
            try {
                property.setClob(FileUtils.readFileToString((File)path, (Charset)StandardCharsets.UTF_8));
                property.setDefaultString(null);
                property.setString(null);
            }
            catch (IOException e) {
                throw new BusinessException("Error while reading: " + path.toString(), (Throwable)e);
            }
        } else {
            if (isDefault) {
                property.setDefaultString(value);
            } else {
                property.setString(value);
            }
            property.setClob(null);
        }
    }
}

