/*
 * Decompiled with CFR 0.152.
 */
package org.appng.cli.commands.property;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import org.apache.commons.lang3.StringUtils;
import org.appng.api.BusinessException;
import org.appng.api.model.Property;
import org.appng.cli.CliEnvironment;
import org.appng.cli.ExecutableCliCommand;
import org.appng.cli.commands.CommandList;
import org.springframework.data.domain.Page;

@Parameters(commandDescription="Lists the available properties.")
public class ListProperties
extends CommandList
implements ExecutableCliCommand {
    @Parameter(names={"-s"}, required=false, description="List only properties of the specified site.")
    private String siteName;
    @Parameter(names={"-a"}, required=false, description="List only properties of the specified application.")
    private String applicationName;
    @Parameter(names={"-f"}, required=false, description="Returns only properties containing the filter expression in their name or value (case-insensitive).")
    private String filterExpression;
    @Parameter(names={"-c"}, required=false, description="Returns only changed properties.")
    private boolean changedValues = false;

    public ListProperties() {
    }

    ListProperties(String siteName) {
        this.siteName = siteName;
    }

    @Override
    public void execute(CliEnvironment cle) throws BusinessException {
        Page properties = cle.getCoreService().getProperties(this.siteName, this.applicationName);
        if (null != properties) {
            this.prettyTable.addColumn("Name");
            this.prettyTable.addColumn("Value");
            this.prettyTable.addColumn("Default value", true);
            this.prettyTable.addColumn("Changed", true);
            for (Property property : properties) {
                if (!this.printRow(property, this.changedValues, this.filterExpression)) continue;
                this.prettyTable.addRow(property.getName(), property.getString(), property.getDefaultString(), this.hasChangedDefaultValue(property));
            }
            cle.setResult(this.renderTable());
        }
    }

    protected boolean printRow(Property property, boolean showOnlyChangedValues, String filterValue) {
        boolean hasChangedDefaultValue = this.hasChangedDefaultValue(property);
        boolean doFilter = this.doFilter(property, filterValue);
        return showOnlyChangedValues && hasChangedDefaultValue && doFilter || !showOnlyChangedValues && doFilter;
    }

    private boolean doFilter(Property property, String filterValue) {
        boolean hasFilter = StringUtils.isNotBlank((CharSequence)filterValue);
        boolean filterMatch = StringUtils.containsIgnoreCase((CharSequence)property.getName(), (CharSequence)filterValue) || StringUtils.containsIgnoreCase((CharSequence)property.getString(), (CharSequence)filterValue);
        return !hasFilter || filterMatch;
    }

    private boolean hasChangedDefaultValue(Property property) {
        return !StringUtils.equals((CharSequence)property.getString(), (CharSequence)property.getDefaultString());
    }
}

