/*
 * Decompiled with CFR 0.152.
 */
package org.appng.cli.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.appng.api.BusinessException;
import org.appng.cli.CliCore;
import org.appng.cli.CliEnvironment;
import org.appng.cli.ExecutableCliCommand;
import org.appng.cli.validators.FileExists;
import org.appng.el.ExpressionEvaluator;
import org.springframework.context.ApplicationContext;

@Parameters(commandDescription="Processes a batch file")
public class CommandBatch
implements ExecutableCliCommand {
    private static final char DOUBLE_QUOTE = '\"';
    private static final String EMPTY = "";
    private static final String SPACE = " ";
    private static final String COMMENT_PREFIX = "#";
    private static final String VAR_PREFIX = "$";
    private static final String VAR_DECLARATION = "def";
    private static final char VAR_ASSIGNMENT = '=';
    private Map<String, String> variables = new HashMap<String, String>();
    @Parameter(names={"-f"}, required=true, description="The name of the batch file.", validateWith={FileExists.class})
    private String fileName;
    @Parameter(names={"-d"}, required=false, description="Print the commands that would be executed after the batch file has been parsed, but do not execute them (dry-run).")
    private boolean dryRun = false;

    private void execute(CliCore cliCore, Properties config, String command) throws IOException {
        String[] args = this.parseLine(command);
        if (args.length > 0) {
            StringBuilder builder = new StringBuilder();
            for (String chunk : args) {
                builder = builder.append(chunk + SPACE);
            }
            CliEnvironment.out.println(builder.toString().trim());
            if (!this.dryRun && cliCore.processCommand(args)) {
                cliCore.perform(config);
            }
        }
    }

    @Override
    public void execute(CliEnvironment cle) throws BusinessException {
        File file = new File(this.fileName).getAbsoluteFile();
        ApplicationContext platformContext = cle.getContext();
        CliCore cliCore = new CliCore();
        cliCore.setContext(platformContext);
        String actual = null;
        try {
            Properties cliConfig = cle.getCliConfig();
            List lines = IOUtils.readLines((InputStream)new FileInputStream(file), (Charset)Charset.defaultCharset());
            Iterator iterator = lines.iterator();
            while (iterator.hasNext()) {
                String command;
                actual = command = (String)iterator.next();
                this.execute(cliCore, cliConfig, command);
            }
        }
        catch (Exception e) {
            if (null != actual) {
                throw new BusinessException("error while performing " + actual, (Throwable)e);
            }
            throw new BusinessException("error while batch-processing " + this.fileName, (Throwable)e);
        }
    }

    protected String[] parseLine(String command) {
        String[] args = new String[]{};
        if (command.startsWith(COMMENT_PREFIX) || StringUtils.isBlank((CharSequence)command)) {
            return args;
        }
        HashMap<String, String> params = new HashMap<String, String>(this.variables);
        params.put("systemEnv", (String)((Object)System.getenv()));
        params.put("systemProp", (String)((Object)System.getProperties()));
        ExpressionEvaluator ee = new ExpressionEvaluator(params);
        String line = (String)ee.evaluate(command, String.class);
        if (line.startsWith(VAR_DECLARATION)) {
            int eqIdx = line.indexOf(61);
            String name = line.substring(VAR_DECLARATION.length() + 1, eqIdx).trim();
            String value = line.substring(eqIdx + 1).trim();
            if (value.indexOf(SPACE) > 0 && value.charAt(0) != '\"') {
                value = '\"' + value + '\"';
            }
            this.variables.put(name, value);
        } else {
            args = this.parse(line).toArray();
            if (args.length == 0 && StringUtils.isNotBlank((CharSequence)line)) {
                args = line.split(SPACE);
            }
        }
        return args;
    }

    protected Line parse(String command) {
        Line line = new Line();
        String current = EMPTY;
        block6: for (char c : command.toCharArray()) {
            switch (line.getCharType(c)) {
                case SPACE: {
                    line.addToken(current);
                    current = EMPTY;
                    continue block6;
                }
                case QUOTE: {
                    current = current + '\"';
                    if (line.hasOpened()) {
                        line.addToken(current);
                        current = EMPTY;
                        line.setOpened(false);
                        line.setSkipAdd(true);
                        continue block6;
                    }
                    line.setOpened(true);
                    continue block6;
                }
                case VARIABLE: {
                    if (current.length() > 0) {
                        line.addToken(current);
                        current = EMPTY;
                    }
                    line.setAssumeVariable(true);
                    continue block6;
                }
                case REGULAR: {
                    current = current + c;
                    line.setSkipAdd(false);
                    continue block6;
                }
            }
        }
        if (current.length() > 0) {
            line.addToken(current);
        }
        return line;
    }

    protected Map<String, String> getVariables() {
        return this.variables;
    }

    private static enum CharType {
        QUOTE,
        REGULAR,
        SPACE,
        VARIABLE;

    }

    private class Line {
        private static final char SINGLE_QUOTE = '\'';
        private List<String> tokens = new ArrayList<String>();
        private boolean hasOpened = false;
        private boolean assumeVariable = false;
        private boolean skipAdd = false;

        private Line() {
        }

        private CharType getCharType(char c) {
            if (!(' ' != c || this.hasOpened || this.assumeVariable || this.skipAdd)) {
                return CharType.SPACE;
            }
            if ('\"' == c || '\'' == c) {
                return CharType.QUOTE;
            }
            if (!this.tokens.isEmpty() && this.tokens.get(0).equals(CommandBatch.VAR_DECLARATION) && '=' == c) {
                return CharType.VARIABLE;
            }
            return CharType.REGULAR;
        }

        private void addToken(String current) {
            String token = current.trim();
            if (token.startsWith(CommandBatch.VAR_PREFIX) && CommandBatch.this.variables.containsKey(this.getVariableName(token))) {
                this.tokens.add((String)CommandBatch.this.variables.get(this.getVariableName(token)));
            } else {
                this.tokens.add(token);
            }
        }

        private String getVariableName(String token) {
            if (token.length() > 1) {
                return token.substring(1);
            }
            return CommandBatch.EMPTY;
        }

        private String[] toArray() {
            return this.tokens.toArray(new String[this.tokens.size()]);
        }

        private boolean hasOpened() {
            return this.hasOpened;
        }

        private void setOpened(boolean opened) {
            this.hasOpened = opened;
        }

        private void setAssumeVariable(boolean assumeVariable) {
            this.assumeVariable = assumeVariable;
        }

        private void setSkipAdd(boolean skipAdd) {
            this.skipAdd = skipAdd;
        }
    }
}

