/*
 * Decompiled with CFR 0.152.
 */
package org.appng.cli;

import java.io.PrintStream;
import java.util.Properties;
import org.appng.api.support.PropertyHolder;
import org.appng.core.service.CoreService;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;

public class CliEnvironment {
    private Boolean devMode = true;
    private String result = null;
    private ApplicationContext platformContext;
    private org.appng.api.model.Properties platformConfig;
    private Properties cliConfig;
    public static PrintStream out = System.out;

    public CliEnvironment(ApplicationContext platformContext, Properties cliConfig) {
        this.platformContext = platformContext;
        this.cliConfig = cliConfig;
    }

    public void initPlatform(Properties defaultOverrides) {
        String platformRootPath = this.cliConfig.getProperty("platformRootPath");
        PropertyHolder propertyHolder = this.getCoreService().initPlatformConfig(defaultOverrides, platformRootPath, this.devMode, true, false);
        this.addPropertyIfExists(propertyHolder, defaultOverrides, "appng.group");
        this.addPropertyIfExists(propertyHolder, defaultOverrides, "appng.user");
        propertyHolder.setFinal();
        this.platformConfig = propertyHolder;
    }

    private void addPropertyIfExists(PropertyHolder propertyHolder, Properties defaultOverrides, String name) {
        if (defaultOverrides.containsKey(name)) {
            propertyHolder.addProperty(name, defaultOverrides.get(name), null);
        }
    }

    public org.appng.api.model.Properties getPlatformConfig() {
        return this.platformConfig;
    }

    public CoreService getCoreService() {
        return (CoreService)this.platformContext.getBean(CoreService.class);
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getResult() {
        return this.result;
    }

    public ApplicationContext getContext() {
        return this.platformContext;
    }

    public Properties getCliConfig() {
        return this.cliConfig;
    }

    public MessageSource getMessageSource() {
        return (MessageSource)this.platformContext.getBean(MessageSource.class);
    }
}

