/*
 * Decompiled with CFR 0.152.
 */
package org.appng.cli.prettytable;

import org.appng.cli.prettytable.PrettyTable;

class TableColumn {
    private final String name;
    private final boolean isVerbose;
    private final int index;
    private int columnWidth;

    TableColumn(String name, boolean isVerbose, int index) {
        this.name = name;
        this.isVerbose = isVerbose;
        this.index = index;
        this.columnWidth = name.length();
    }

    String getName() {
        return this.name;
    }

    boolean isVerbose() {
        return this.isVerbose;
    }

    int getIndex() {
        return this.index;
    }

    void setCellWidth(int cellWidth) {
        if (cellWidth > this.columnWidth) {
            this.columnWidth = cellWidth;
        }
    }

    public int getCellWidth() {
        return this.columnWidth;
    }

    public String render(boolean withBorders, boolean beVerbose) {
        if (!this.isVerbose || beVerbose) {
            if (withBorders) {
                return PrettyTable.bordered(this.name, this.columnWidth);
            }
            return PrettyTable.tabbed(this.name);
        }
        return null;
    }
}

