/*
 * Decompiled with CFR 0.152.
 */
package org.appng.cli.commands.subject;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import org.appng.api.BusinessException;
import org.appng.api.model.Subject;
import org.appng.cli.CliEnvironment;
import org.appng.cli.ExecutableCliCommand;
import org.appng.core.domain.SubjectImpl;

@Parameters(commandDescription="Deletes a subject.")
public class DeleteSubject
implements ExecutableCliCommand {
    @Parameter(names={"-n"}, required=true, description="The subject name.")
    private String subjectName;

    public DeleteSubject() {
    }

    public DeleteSubject(String subjectName) {
        this.subjectName = subjectName;
    }

    @Override
    public void execute(CliEnvironment cle) throws BusinessException {
        SubjectImpl subject = cle.getCoreService().getSubjectByName(this.subjectName, false);
        if (null == subject) {
            throw new BusinessException("Subject not found: " + this.subjectName);
        }
        cle.getCoreService().deleteSubject((Subject)subject);
    }
}

