/*
 * Decompiled with CFR 0.152.
 */
package org.appng.cli.commands.site;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import org.appng.api.BusinessException;
import org.appng.cli.CliEnvironment;
import org.appng.cli.ExecutableCliCommand;
import org.appng.core.domain.SiteImpl;

@Parameters(commandDescription="Creates a site.")
public class CreateSite
implements ExecutableCliCommand {
    @Parameter(names={"-n"}, required=true, description="The site name.")
    private String name;
    @Parameter(names={"-h"}, required=true, description="The site host.")
    private String host;
    @Parameter(names={"-d"}, required=true, description="The site domain, as it should appear in URLs (incl. protocol and optionally port).")
    private String domain;
    @Parameter(names={"-t"}, required=false, description="The site description.")
    private String description;
    @Parameter(names={"-e"}, description="Enable site.")
    private boolean isEnabled = false;
    @Parameter(names={"-r"}, description="create a repository for the site.")
    private boolean createRepo = false;

    public CreateSite() {
    }

    CreateSite(String name, String host, String domain, String description, boolean isEnabled, boolean createRepo) {
        this.name = name;
        this.host = host;
        this.domain = domain;
        this.description = description;
        this.isEnabled = isEnabled;
        this.createRepo = createRepo;
    }

    @Override
    public void execute(CliEnvironment cle) throws BusinessException {
        SiteImpl site = new SiteImpl();
        site.setName(this.name);
        site.setHost(this.host);
        site.setDomain(this.domain);
        site.setDescription(this.description);
        site.setActive(this.isEnabled);
        site.setCreateRepository(this.createRepo);
        cle.getCoreService().createSite(site);
    }
}

