/*
 * Decompiled with CFR 0.152.
 */
package org.appng.cli.commands.group;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import org.appng.api.BusinessException;
import org.appng.cli.CliEnvironment;
import org.appng.cli.ExecutableCliCommand;
import org.appng.core.domain.GroupImpl;

@Parameters(commandDescription="Deletes a group.")
public class DeleteGroup
implements ExecutableCliCommand {
    @Parameter(names={"-n"}, required=true, description="The group name.")
    private String name;

    public DeleteGroup() {
    }

    DeleteGroup(String name) {
        this.name = name;
    }

    @Override
    public void execute(CliEnvironment cle) throws BusinessException {
        GroupImpl group = cle.getCoreService().getGroupByName(this.name);
        if (null != group) {
            if (group.isDefaultAdmin()) {
                throw new BusinessException("Not allowed to delete default admin group: " + group);
            }
        } else {
            throw new BusinessException("No such group: " + group);
        }
        cle.getCoreService().deleteGroup(group);
    }
}

