/*
 * Decompiled with CFR 0.152.
 */
package org.appng.cli.commands.applicationrole;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.List;
import org.appng.api.BusinessException;
import org.appng.cli.CliEnvironment;
import org.appng.cli.ExecutableCliCommand;

@Parameters(commandDescription="Adds a application role to a group.")
public class AddRole
implements ExecutableCliCommand {
    @Parameter(names={"-g"}, required=true, description="The group name.")
    private String groupName;
    @Parameter(names={"-a"}, required=true, description="The application name.")
    private String applicationName;
    @Parameter(names={"-r"}, required=true, variableArity=true, description="A application role name. Multiple values can be provided (separated by space).")
    private List<String> applicationRoleNames;
    @Parameter(names={"-c"}, required=false, description="Clear existing application role of the group.")
    private boolean clear;

    @Override
    public void execute(CliEnvironment cle) throws BusinessException {
        try {
            cle.getCoreService().addApplicationRolesToGroup(this.groupName, this.applicationName, this.applicationRoleNames, this.clear);
        }
        catch (Exception e) {
            throw new BusinessException("Invalid group or application role id.", (Throwable)e);
        }
    }
}

