/*
 * Decompiled with CFR 0.152.
 */
package org.appng.cli.commands;

import com.beust.jcommander.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.appng.core.domain.DatabaseConnection;
import org.appng.core.service.DatabaseService;
import org.flywaydb.core.api.MigrationInfo;

public class CommandMain {
    @Parameter
    private List<String> parameters = new ArrayList<String>();
    @Parameter(names={"-h", "-help"}, help=true, description="Prints the usage of the appNG Command Line Interface")
    private boolean usage = false;
    @Parameter(names={"-schemaexport"}, description="Exports the schema to the database. Use only during development!")
    private boolean schemaExport = false;
    @Parameter(names={"-showsql"}, description="Prints formatted SQL.")
    private boolean showSql = false;
    @Parameter(names={"-plainsql"}, description="Do not format the SQL.")
    private boolean plainsql = false;
    @Parameter(names={"-initdatabase", "-i"}, description="Initializes the database. Use this in production. Must be executed also if connection parameters like user name or password of the database root connection have been changed.")
    private boolean initDatabase = false;
    @Parameter(names={"-managed", "-m"}, description="Make the root-connection managed by appNG")
    private boolean connectionManaged = false;

    public List<String> getParameters() {
        return this.parameters;
    }

    public boolean isUsage() {
        return this.usage;
    }

    public Map<String, String> getHibernateParams() {
        HashMap<String, String> hibernateParams = new HashMap<String, String>();
        if (this.schemaExport) {
            hibernateParams.put("hibernate.hbm2ddl.auto", "create");
        }
        hibernateParams.put("hibernate.show_sql", String.valueOf(this.showSql));
        hibernateParams.put("hibernate.format_sql", String.valueOf(!this.plainsql));
        return hibernateParams;
    }

    public boolean isSchemaExport() {
        return this.schemaExport;
    }

    public boolean isInitDatabase() {
        return this.initDatabase;
    }

    public boolean isConnectionManaged() {
        return this.connectionManaged;
    }

    public MigrationInfo doInitDatabase(DatabaseService databaseService, Properties config) {
        DatabaseConnection platformConnection = databaseService.initDatabase(config);
        MigrationInfo status = databaseService.status(platformConnection);
        if (null != status) {
            platformConnection.setManaged(this.isConnectionManaged());
            databaseService.setActiveConnection(platformConnection, true);
        }
        return status;
    }
}

