/*
 * Decompiled with CFR 0.152.
 */
package org.appng.cli.servlet;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.appng.cli.CliBootstrap;
import org.appng.cli.CliEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallListener
implements ServletContextListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstallListener.class);
    private static final String DATE_PATTERN = "yyyy-MM-dd-HH-mm";
    private static final String BATCH_FILE = "auto-install.list";
    private static final String INSTALL_PATH = "/WEB-INF/conf/auto-install.list";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent sce) {
        ServletContext ctx = sce.getServletContext();
        File autoInstall = null;
        String resource = ctx.getRealPath(INSTALL_PATH);
        if (null == resource) {
            LOGGER.info("{} not present", (Object)INSTALL_PATH);
            return;
        }
        String message = null;
        try {
            autoInstall = new File(resource);
            if (autoInstall.exists()) {
                LOGGER.info("processing " + resource);
                System.getProperties().put("APPNG_HOME", ctx.getRealPath("/"));
                ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
                CliEnvironment.out = new PrintStream(bytesOut);
                String[] args = new String[]{"batch", "-f", resource};
                int status = CliBootstrap.run(args);
                message = new String(bytesOut.toByteArray());
                LOGGER.debug(message);
                if (0 != status) {
                    LOGGER.warn("CLI returned status {}", (Object)status);
                }
                LOGGER.info("done processing {}", (Object)resource);
            } else {
                LOGGER.debug("{} not present", (Object)resource);
            }
        }
        catch (Exception e) {
            LOGGER.error("error while processing " + resource, (Throwable)e);
        }
        finally {
            if (null != autoInstall && autoInstall.exists()) {
                String timestamp = DateFormatUtils.format((long)System.currentTimeMillis(), (String)DATE_PATTERN);
                String targetName = "auto-install.list." + timestamp;
                File processingResult = new File(autoInstall.getParent(), targetName);
                try {
                    if (null != message) {
                        FileUtils.write((File)processingResult, message, (Charset)Charset.defaultCharset(), (boolean)false);
                        FileUtils.deleteQuietly((File)autoInstall);
                    } else {
                        FileUtils.moveFile((File)autoInstall, (File)processingResult);
                    }
                }
                catch (IOException e) {
                    LOGGER.warn("error while creating " + processingResult.getPath(), (Throwable)e);
                }
            }
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

